/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class DarkOakTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<DarkOakTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> DarkOakTrunkPlacer.trunkPlacerParts(instance).apply((Applicative)instance, DarkOakTrunkPlacer::new));

    public DarkOakTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    @Override
    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.DARK_OAK_TRUNK_PLACER;
    }

    @Override
    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockPos = startPos.below();
        DarkOakTrunkPlacer.setDirtAt(world, replacer, random, blockPos, config);
        DarkOakTrunkPlacer.setDirtAt(world, replacer, random, blockPos.east(), config);
        DarkOakTrunkPlacer.setDirtAt(world, replacer, random, blockPos.south(), config);
        DarkOakTrunkPlacer.setDirtAt(world, replacer, random, blockPos.south().east(), config);
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int i = height - random.nextInt(4);
        int j = 2 - random.nextInt(3);
        int k = startPos.getX();
        int l = startPos.getY();
        int m = startPos.getZ();
        int n = k;
        int o = m;
        int p = l + height - 1;
        for (int q = 0; q < height; ++q) {
            int r;
            BlockPos blockPos2;
            if (q >= i && j > 0) {
                n += direction.getStepX();
                o += direction.getStepZ();
                --j;
            }
            if (!TreeFeature.isAirOrLeaves(world, blockPos2 = new BlockPos(n, r = l + q, o))) continue;
            this.placeLog(world, replacer, random, blockPos2, config);
            this.placeLog(world, replacer, random, blockPos2.east(), config);
            this.placeLog(world, replacer, random, blockPos2.south(), config);
            this.placeLog(world, replacer, random, blockPos2.east().south(), config);
        }
        list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(n, p, o), 0, true));
        for (int s = -1; s <= 2; ++s) {
            for (int t = -1; t <= 2; ++t) {
                if (s >= 0 && s <= 1 && t >= 0 && t <= 1 || random.nextInt(3) > 0) continue;
                int u = random.nextInt(3) + 2;
                for (int v = 0; v < u; ++v) {
                    this.placeLog(world, replacer, random, new BlockPos(k + s, p - v - 1, m + t), config);
                }
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(n + s, p, o + t), 0, false));
            }
        }
        return list;
    }
}

