/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class TrapezoidHeight
extends HeightProvider {
    public static final MapCodec<TrapezoidHeight> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive), (App)Codec.INT.optionalFieldOf("plateau", (Object)0).forGetter(trapezoidHeight -> trapezoidHeight.plateau)).apply((Applicative)instance, TrapezoidHeight::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;
    private final int plateau;

    private TrapezoidHeight(VerticalAnchor minOffset, VerticalAnchor maxOffset, int plateau) {
        this.minInclusive = minOffset;
        this.maxInclusive = maxOffset;
        this.plateau = plateau;
    }

    public static TrapezoidHeight of(VerticalAnchor minOffset, VerticalAnchor maxOffset, int plateau) {
        return new TrapezoidHeight(minOffset, maxOffset, plateau);
    }

    public static TrapezoidHeight of(VerticalAnchor minOffset, VerticalAnchor maxOffset) {
        return TrapezoidHeight.of(minOffset, maxOffset, 0);
    }

    @Override
    @Override
    public int sample(RandomSource random, WorldGenerationContext context) {
        int j;
        int i = this.minInclusive.resolveY(context);
        if (i > (j = this.maxInclusive.resolveY(context))) {
            LOGGER.warn("Empty height range: {}", (Object)this);
            return i;
        }
        int k = j - i;
        if (this.plateau >= k) {
            return Mth.randomBetweenInclusive(random, i, j);
        }
        int l = (k - this.plateau) / 2;
        int m = k - l;
        return i + Mth.randomBetweenInclusive(random, 0, m) + Mth.randomBetweenInclusive(random, 0, l);
    }

    @Override
    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.TRAPEZOID;
    }

    @Override
    public String toString() {
        if (this.plateau == 0) {
            return "triangle (" + String.valueOf(this.minInclusive) + "-" + String.valueOf(this.maxInclusive) + ")";
        }
        return "trapezoid(" + this.plateau + ") in [" + String.valueOf(this.minInclusive) + "-" + String.valueOf(this.maxInclusive) + "]";
    }
}

