/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools.alias;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.Direct;
import net.minecraft.world.level.levelgen.structure.pools.alias.Random;
import net.minecraft.world.level.levelgen.structure.pools.alias.RandomGroup;

public interface PoolAliasBinding {
    public static final Codec<PoolAliasBinding> CODEC = BuiltInRegistries.POOL_ALIAS_BINDING_TYPE.byNameCodec().dispatch(PoolAliasBinding::codec, Function.identity());

    public void forEachResolved(RandomSource var1, BiConsumer<ResourceKey<StructureTemplatePool>, ResourceKey<StructureTemplatePool>> var2);

    public Stream<ResourceKey<StructureTemplatePool>> allTargets();

    public static Direct direct(String alias, String target) {
        return PoolAliasBinding.direct(Pools.createKey(alias), Pools.createKey(target));
    }

    public static Direct direct(ResourceKey<StructureTemplatePool> alias, ResourceKey<StructureTemplatePool> target) {
        return new Direct(alias, target);
    }

    public static Random random(String alias, SimpleWeightedRandomList<String> targets) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        targets.unwrap().forEach(target -> builder.add(Pools.createKey((String)target.data()), target.getWeight().asInt()));
        return PoolAliasBinding.random(Pools.createKey(alias), builder.build());
    }

    public static Random random(ResourceKey<StructureTemplatePool> alias, SimpleWeightedRandomList<ResourceKey<StructureTemplatePool>> targets) {
        return new Random(alias, targets);
    }

    public static RandomGroup randomGroup(SimpleWeightedRandomList<List<PoolAliasBinding>> groups) {
        return new RandomGroup(groups);
    }

    public MapCodec<? extends PoolAliasBinding> codec();
}

