/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;

public class OceanMonumentStructure
extends Structure {
    public static final MapCodec<OceanMonumentStructure> CODEC = OceanMonumentStructure.simpleCodec(OceanMonumentStructure::new);

    public OceanMonumentStructure(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int i = context.chunkPos().getBlockX(9);
        int j = context.chunkPos().getBlockZ(9);
        Set<Holder<Biome>> set = context.biomeSource().getBiomesWithin(i, context.chunkGenerator().getSeaLevel(), j, 29, context.randomState().sampler());
        for (Holder<Biome> holder : set) {
            if (holder.is(BiomeTags.REQUIRED_OCEAN_MONUMENT_SURROUNDING)) continue;
            return Optional.empty();
        }
        return OceanMonumentStructure.onTopOfChunkCenter(context, Heightmap.Types.OCEAN_FLOOR_WG, collector -> OceanMonumentStructure.generatePieces(collector, context));
    }

    private static StructurePiece createTopPiece(ChunkPos pos, WorldgenRandom random) {
        int i = pos.getMinBlockX() - 29;
        int j = pos.getMinBlockZ() - 29;
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        return new OceanMonumentPieces.MonumentBuilding(random, i, j, direction);
    }

    private static void generatePieces(StructurePiecesBuilder collector, Structure.GenerationContext context) {
        collector.addPiece(OceanMonumentStructure.createTopPiece(context.chunkPos(), context.random()));
    }

    public static PiecesContainer regeneratePiecesAfterLoad(ChunkPos pos, long worldSeed, PiecesContainer pieces) {
        if (pieces.isEmpty()) {
            return pieces;
        }
        WorldgenRandom worldgenRandom = new WorldgenRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        worldgenRandom.setLargeFeatureSeed(worldSeed, pos.x, pos.z);
        StructurePiece structurePiece = pieces.pieces().get(0);
        BoundingBox boundingBox = structurePiece.getBoundingBox();
        int i = boundingBox.minX();
        int j = boundingBox.minZ();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(worldgenRandom);
        Direction direction2 = Objects.requireNonNullElse(structurePiece.getOrientation(), direction);
        OceanMonumentPieces.MonumentBuilding structurePiece2 = new OceanMonumentPieces.MonumentBuilding(worldgenRandom, i, j, direction2);
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        structurePiecesBuilder.addPiece(structurePiece2);
        return structurePiecesBuilder.build();
    }

    @Override
    @Override
    public StructureType<?> type() {
        return StructureType.OCEAN_MONUMENT;
    }
}

