/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> UNLIMITED_CODEC = ListOperation.codec(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> codec(int maxSize) {
        return Type.CODEC.dispatchMap("mode", ListOperation::mode, mode -> mode.mapCodec).validate(operation -> {
            int j;
            ReplaceSection replaceSection;
            if (operation instanceof ReplaceSection && (replaceSection = (ReplaceSection)operation).size().isPresent() && (j = replaceSection.size().get().intValue()) > maxSize) {
                return DataResult.error(() -> "Size value too large: " + j + ", max size is " + maxSize);
            }
            return DataResult.success((Object)operation);
        });
    }

    public Type mode();

    default public <T> List<T> apply(List<T> current, List<T> values) {
        return this.apply(current, values, Integer.MAX_VALUE);
    }

    public <T> List<T> apply(List<T> var1, List<T> var2, int var3);

    public static enum Type implements StringRepresentable
    {
        REPLACE_ALL("replace_all", ReplaceAll.MAP_CODEC),
        REPLACE_SECTION("replace_section", ReplaceSection.MAP_CODEC),
        INSERT("insert", Insert.MAP_CODEC),
        APPEND("append", Append.MAP_CODEC);

        public static final Codec<Type> CODEC;
        private final String id;
        final MapCodec<? extends ListOperation> mapCodec;

        private Type(String id, MapCodec<? extends ListOperation> codec) {
            this.id = id;
            this.mapCodec = codec;
        }

        public MapCodec<? extends ListOperation> mapCodec() {
            return this.mapCodec;
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record ReplaceSection(int offset, Optional<Integer> size) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<ReplaceSection> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(ReplaceSection::offset), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("size").forGetter(ReplaceSection::size)).apply((Applicative)instance, ReplaceSection::new));

        public ReplaceSection(int offset) {
            this(offset, Optional.empty());
        }

        @Override
        @Override
        public Type mode() {
            return Type.REPLACE_SECTION;
        }

        @Override
        @Override
        public <T> List<T> apply(List<T> current, List<T> values, int maxSize) {
            ImmutableList list;
            int i = current.size();
            if (this.offset > i) {
                LOGGER.error("Cannot replace when offset is out of bounds");
                return current;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(current.subList(0, this.offset));
            builder.addAll(values);
            int j = this.offset + this.size.orElse(values.size());
            if (j < i) {
                builder.addAll(current.subList(j, i));
            }
            if ((list = builder.build()).size() > maxSize) {
                LOGGER.error("Contents overflow in section replacement");
                return current;
            }
            return list;
        }
    }

    public record StandAlone<T>(List<T> value, ListOperation operation) {
        public static <T> Codec<StandAlone<T>> codec(Codec<T> codec, int maxSize) {
            return RecordCodecBuilder.create(instance -> instance.group((App)codec.sizeLimitedListOf(maxSize).fieldOf("values").forGetter(values -> values.value), (App)ListOperation.codec(maxSize).forGetter(values -> values.operation)).apply((Applicative)instance, StandAlone::new));
        }

        public List<T> apply(List<T> current) {
            return this.operation.apply(current, this.value);
        }
    }

    public static class Append
    implements ListOperation {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final Append INSTANCE = new Append();
        public static final MapCodec<Append> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private Append() {
        }

        @Override
        @Override
        public Type mode() {
            return Type.APPEND;
        }

        @Override
        @Override
        public <T> List<T> apply(List<T> current, List<T> values, int maxSize) {
            if (current.size() + values.size() > maxSize) {
                LOGGER.error("Contents overflow in section append");
                return current;
            }
            return Stream.concat(current.stream(), values.stream()).toList();
        }
    }

    public record Insert(int offset) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Insert> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(Insert::offset)).apply((Applicative)instance, Insert::new));

        @Override
        @Override
        public Type mode() {
            return Type.INSERT;
        }

        @Override
        @Override
        public <T> List<T> apply(List<T> current, List<T> values, int maxSize) {
            int i = current.size();
            if (this.offset > i) {
                LOGGER.error("Cannot insert when offset is out of bounds");
                return current;
            }
            if (i + values.size() > maxSize) {
                LOGGER.error("Contents overflow in section insertion");
                return current;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(current.subList(0, this.offset));
            builder.addAll(values);
            builder.addAll(current.subList(this.offset, i));
            return builder.build();
        }
    }

    public static class ReplaceAll
    implements ListOperation {
        public static final ReplaceAll INSTANCE = new ReplaceAll();
        public static final MapCodec<ReplaceAll> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private ReplaceAll() {
        }

        @Override
        @Override
        public Type mode() {
            return Type.REPLACE_ALL;
        }

        @Override
        @Override
        public <T> List<T> apply(List<T> current, List<T> values, int maxSize) {
            return values;
        }
    }
}

