/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public class SequenceFunction
implements LootItemFunction {
    public static final MapCodec<SequenceFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootItemFunctions.TYPED_CODEC.listOf().fieldOf("functions").forGetter(function -> function.functions)).apply((Applicative)instance, SequenceFunction::new));
    public static final Codec<SequenceFunction> INLINE_CODEC = LootItemFunctions.TYPED_CODEC.listOf().xmap(SequenceFunction::new, function -> function.functions);
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;

    private SequenceFunction(List<LootItemFunction> terms) {
        this.functions = terms;
        this.compositeFunction = LootItemFunctions.compose(terms);
    }

    public static SequenceFunction of(List<LootItemFunction> terms) {
        return new SequenceFunction(List.copyOf(terms));
    }

    @Override
    @Override
    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        return this.compositeFunction.apply(itemStack, lootContext);
    }

    @Override
    @Override
    public void validate(ValidationContext reporter) {
        LootItemFunction.super.validate(reporter);
        for (int i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).validate(reporter.forChild(".function[" + i + "]"));
        }
    }

    @Override
    public LootItemFunctionType<SequenceFunction> getType() {
        return LootItemFunctions.SEQUENCE;
    }

    @Override
    public /* synthetic */ Object apply(Object object, Object object2) {
        return this.apply((ItemStack)object, (LootContext)object2);
    }
}

