/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;

public class ContentValidationException
extends Exception {
    private final Path directory;
    private final List<ForbiddenSymlinkInfo> entries;

    public ContentValidationException(Path path, List<ForbiddenSymlinkInfo> symlinks) {
        this.directory = path;
        this.entries = symlinks;
    }

    @Override
    @Override
    public String getMessage() {
        return ContentValidationException.getMessage(this.directory, this.entries);
    }

    public static String getMessage(Path path, List<ForbiddenSymlinkInfo> symlinks) {
        return "Failed to validate '" + String.valueOf(path) + "'. Found forbidden symlinks: " + symlinks.stream().map(symlink -> String.valueOf(symlink.link()) + "->" + String.valueOf(symlink.target())).collect(Collectors.joining(", "));
    }
}

