/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.banner.CraftPatternType;

public class CraftBanner
extends CraftBlockEntityState<BannerBlockEntity>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(World world, BannerBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBanner(CraftBanner state, Location location) {
        super(state, location);
        this.base = state.getBaseColor();
        this.patterns = state.getPatterns();
    }

    @Override
    public void load(BannerBlockEntity banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((byte)((AbstractBannerBlock)this.data.getBlock()).getColor().getId()));
        this.patterns = new ArrayList<Pattern>();
        if (banner.getPatterns() != null) {
            for (int i = 0; i < banner.getPatterns().layers().size(); ++i) {
                BannerPatternLayers.Layer p = banner.getPatterns().layers().get(i);
                Optional type = CraftRegistry.unwrapAndConvertHolder(Registry.BANNER_PATTERN, p.pattern());
                if (type.isEmpty()) continue;
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)((byte)p.color().getId())), (PatternType)type.get()));
            }
        }
    }

    public DyeColor getBaseColor() {
        return this.base;
    }

    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.base = color;
    }

    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(BannerBlockEntity banner) {
        super.applyTo(banner);
        banner.baseColor = net.minecraft.world.item.DyeColor.byId(this.base.getWoolData());
        ArrayList<BannerPatternLayers.Layer> newPatterns = new ArrayList<BannerPatternLayers.Layer>();
        for (Pattern p : this.patterns) {
            newPatterns.add(new BannerPatternLayers.Layer(CraftPatternType.bukkitToMinecraftHolder(p.getPattern()), net.minecraft.world.item.DyeColor.byId(p.getColor().getWoolData())));
        }
        banner.setPatterns(new BannerPatternLayers(newPatterns));
    }

    @Override
    public CraftBanner copy() {
        return new CraftBanner(this, null);
    }

    @Override
    public CraftBanner copy(Location location) {
        return new CraftBanner(this, location);
    }

    public Component customName() {
        return PaperAdventure.asAdventure(((BannerBlockEntity)this.getSnapshot()).getCustomName());
    }

    public void customName(Component customName) {
        ((BannerBlockEntity)this.getSnapshot()).name = PaperAdventure.asVanilla(customName);
    }

    public String getCustomName() {
        return (String)LegacyComponentSerializer.legacySection().serializeOrNull(this.customName());
    }

    public void setCustomName(String name) {
        this.customName(LegacyComponentSerializer.legacySection().deserializeOrNull((Object)name));
    }
}

