/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.inventory.Inventory;

public class CraftBarrel
extends CraftLootable<BarrelBlockEntity>
implements Barrel {
    public CraftBarrel(World world, BarrelBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBarrel(CraftBarrel state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    public Inventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getTileEntity());
    }

    public void open() {
        BlockState blockData;
        boolean open;
        this.requirePlaced();
        if (!((BarrelBlockEntity)this.getTileEntity()).openersCounter.opened && !(open = (blockData = ((BarrelBlockEntity)this.getTileEntity()).getBlockState()).getValue(BarrelBlock.OPEN).booleanValue())) {
            ((BarrelBlockEntity)this.getTileEntity()).updateBlockState(blockData, true);
            if (this.getWorldHandle() instanceof Level) {
                ((BarrelBlockEntity)this.getTileEntity()).playSound(blockData, SoundEvents.BARREL_OPEN);
            }
        }
        ((BarrelBlockEntity)this.getTileEntity()).openersCounter.opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((BarrelBlockEntity)this.getTileEntity()).openersCounter.opened) {
            BlockState blockData = ((BarrelBlockEntity)this.getTileEntity()).getBlockState();
            ((BarrelBlockEntity)this.getTileEntity()).updateBlockState(blockData, false);
            if (this.getWorldHandle() instanceof Level) {
                ((BarrelBlockEntity)this.getTileEntity()).playSound(blockData, SoundEvents.BARREL_CLOSE);
            }
        }
        ((BarrelBlockEntity)this.getTileEntity()).openersCounter.opened = false;
    }

    @Override
    public CraftBarrel copy() {
        return new CraftBarrel(this, null);
    }

    @Override
    public CraftBarrel copy(Location location) {
        return new CraftBarrel(this, location);
    }

    public boolean isOpen() {
        return ((BarrelBlockEntity)this.getTileEntity()).openersCounter.opened;
    }
}

