/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.item.FallingBlockEntity;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.FallingBlock;

public class CraftFallingBlock
extends CraftEntity
implements FallingBlock {
    public CraftFallingBlock(CraftServer server, FallingBlockEntity entity) {
        super(server, entity);
    }

    @Override
    public FallingBlockEntity getHandle() {
        return (FallingBlockEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFallingBlock";
    }

    public Material getMaterial() {
        return this.getBlockData().getMaterial();
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getHandle().getBlockState());
    }

    public void setBlockData(BlockData blockData) {
        net.minecraft.world.level.block.state.BlockState newState;
        Preconditions.checkArgument((blockData != null ? 1 : 0) != 0, (Object)"blockData");
        net.minecraft.world.level.block.state.BlockState oldState = this.getHandle().blockState;
        this.getHandle().blockState = newState = ((CraftBlockData)blockData).getState();
        this.getHandle().blockData = null;
        if (oldState != newState) {
            this.update();
        }
    }

    public BlockState getBlockState() {
        return CraftBlockStates.getBlockState(this.getHandle().blockState, this.getHandle().blockData);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState");
        this.setBlockData(blockState.getBlockData());
        if (blockState instanceof CraftBlockEntityState) {
            CraftBlockEntityState tileEntity = (CraftBlockEntityState)blockState;
            this.getHandle().blockData = tileEntity.getSnapshotNBT();
        }
    }

    public boolean getDropItem() {
        return this.getHandle().dropItem;
    }

    public void setDropItem(boolean drop) {
        this.getHandle().dropItem = drop;
    }

    public boolean getCancelDrop() {
        return this.getHandle().cancelDrop;
    }

    public void setCancelDrop(boolean cancelDrop) {
        this.getHandle().cancelDrop = cancelDrop;
    }

    public boolean canHurtEntities() {
        return this.getHandle().hurtEntities;
    }

    public void setHurtEntities(boolean hurtEntities) {
        this.getHandle().hurtEntities = hurtEntities;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().time = value;
    }

    public float getDamagePerBlock() {
        return this.getHandle().fallDamagePerDistance;
    }

    public void setDamagePerBlock(float damage) {
        Preconditions.checkArgument(((double)damage >= 0.0 ? 1 : 0) != 0, (String)"damage must be >= 0.0, given %s", (Object)Float.valueOf(damage));
        this.getHandle().fallDamagePerDistance = damage;
        if ((double)damage > 0.0) {
            this.setHurtEntities(true);
        }
    }

    public int getMaxDamage() {
        return this.getHandle().fallDamageMax;
    }

    public void setMaxDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, given %s", (int)damage);
        this.getHandle().fallDamageMax = damage;
        if (damage > 0) {
            this.setHurtEntities(true);
        }
    }

    public boolean doesAutoExpire() {
        return this.getHandle().autoExpire;
    }

    public void shouldAutoExpire(boolean autoExpires) {
        this.getHandle().autoExpire = autoExpires;
    }
}

