/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.bukkit.craftbukkit.inventory.CraftMerchantRecipe;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.MerchantRecipe;

public class CraftMerchant
implements org.bukkit.inventory.Merchant {
    protected final Merchant merchant;

    public CraftMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public List<MerchantRecipe> getRecipes() {
        return List.copyOf(Lists.transform((List)this.merchant.getOffers(), (Function)new Function<MerchantOffer, MerchantRecipe>(this){

            public MerchantRecipe apply(MerchantOffer recipe) {
                return recipe.asBukkit();
            }
        }));
    }

    public void setRecipes(List<MerchantRecipe> recipes) {
        MerchantOffers recipesList = this.merchant.getOffers();
        recipesList.clear();
        for (MerchantRecipe recipe : recipes) {
            recipesList.add(CraftMerchantRecipe.fromBukkit(recipe).toMinecraft());
        }
    }

    public MerchantRecipe getRecipe(int i) {
        return ((MerchantOffer)this.merchant.getOffers().get(i)).asBukkit();
    }

    public void setRecipe(int i, MerchantRecipe merchantRecipe) {
        this.merchant.getOffers().set(i, CraftMerchantRecipe.fromBukkit(merchantRecipe).toMinecraft());
    }

    public int getRecipeCount() {
        return this.merchant.getOffers().size();
    }

    public boolean isTrading() {
        return this.getTrader() != null;
    }

    public HumanEntity getTrader() {
        Player eh = this.merchant.getTradingPlayer();
        return eh == null ? null : eh.getBukkitEntity();
    }

    public int hashCode() {
        return this.merchant.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftMerchant && ((CraftMerchant)obj).merchant.equals(this.merchant);
    }
}

