/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    static final CraftMetaItem.ItemMetaKeyType<CustomData> BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.BLOCK_ENTITY_DATA, "BlockEntityTag");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG_CUSTOM_DATA = new CraftMetaItem.ItemMetaKey("block-entity-tag");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_COMPONENTS = new CraftMetaItem.ItemMetaKey("block-entity-components");
    final Material material;
    DataComponentMap components;
    CustomData blockEntityTag;
    private CompoundTag internalTag;

    private Material materialForBlockEntityType() {
        return this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack();
    }

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.components = this.components != null ? this.components : DataComponentMap.EMPTY;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : CustomData.EMPTY;
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.components = DataComponentMap.EMPTY;
            this.blockEntityTag = CustomData.EMPTY;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.components = te.components;
        this.blockEntityTag = te.blockEntityTag;
    }

    CraftMetaBlockState(DataComponentPatch tag, Material material, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        this.components = this.components != null ? this.components : DataComponentMap.EMPTY;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : CustomData.EMPTY;
        this.material = material;
        this.updateBlockState(tag);
    }

    private void updateBlockState(DataComponentPatch tag) {
        CraftMetaBlockState.getOrEmpty(tag, BLOCK_ENTITY_TAG).ifPresent(nbt -> {
            this.blockEntityTag = nbt;
        });
        if (!tag.isEmpty()) {
            DataComponentMap.Builder map = DataComponentMap.builder();
            BlockEntity dummyBlockEntity = Objects.requireNonNull(CraftBlockStates.createNewTileEntity(this.materialForBlockEntityType()));
            Set<DataComponentType<?>> applied = dummyBlockEntity.applyComponentsSet(DataComponentMap.EMPTY, DataComponentPatch.EMPTY);
            for (DataComponentType<?> seen : applied) {
                this.unhandledTags.clear(seen);
            }
            if (!applied.isEmpty()) {
                for (DataComponentType<?> type : applied) {
                    if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(type)) continue;
                    CraftMetaBlockState.getOrEmpty(tag, type).ifPresent(value -> map.set(type, value));
                }
            }
            this.components = map.build();
        }
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        this.components = this.components != null ? this.components : DataComponentMap.EMPTY;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : CustomData.EMPTY;
        String matName = SerializableMeta.getString(map, "blockMaterial", true);
        Material m = Material.getMaterial((String)matName);
        this.material = m != null ? m : Material.AIR;
        if (this.internalTag != null) {
            this.setBlockState(CraftMetaBlockState.getBlockState(this.material, this.internalTag));
        }
        this.internalTag = null;
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        CompoundTag nbt = this.blockEntityTag.copyTag();
        if (nbt.contains("id", 8)) {
            tag.put(BLOCK_ENTITY_TAG, CustomData.of(nbt));
        } else if (!nbt.isEmpty()) {
            BlockEntity.addEntityType(nbt, Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
            tag.put(BLOCK_ENTITY_TAG, CustomData.of(nbt));
        }
        for (TypedDataComponent<?> component : this.components) {
            if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(component.type())) continue;
            tag.builder.set(component);
        }
    }

    @Override
    void deserializeInternal(CompoundTag tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.contains(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10)) {
            this.internalTag = tag.getCompound(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
            return;
        }
        if (tag.contains(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT, 10)) {
            this.blockEntityTag = CustomData.of(tag.getCompound(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT));
        }
        if (tag.contains(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT, 10)) {
            this.components = (DataComponentMap)DataComponentMap.CODEC.parse(CraftRegistry.getMinecraftRegistry().createSerializationContext(NbtOps.INSTANCE), (Object)tag.getCompound(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT)).getOrThrow();
        }
    }

    @Override
    void serializeInternal(Map<String, Tag> internalTags) {
        if (!this.blockEntityTag.isEmpty()) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT, this.blockEntityTag.getUnsafe());
        }
        if (!this.components.isEmpty()) {
            Tag componentsTag = (Tag)DataComponentMap.CODEC.encodeStart(CraftRegistry.getMinecraftRegistry().createSerializationContext(NbtOps.INSTANCE), (Object)this.components).getOrThrow();
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT, componentsTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        hash = 61 * hash + this.blockEntityTag.hashCode();
        return original != (hash = 61 * hash + this.components.hashCode()) ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return com.google.common.base.Objects.equal((Object)this.blockEntityTag, (Object)that.blockEntityTag) && com.google.common.base.Objects.equal((Object)this.components, (Object)that.components);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag.isEmpty() && this.components.isEmpty());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag.isEmpty() && this.components.isEmpty();
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        meta.blockEntityTag = this.blockEntityTag;
        meta.components = this.components;
        return meta;
    }

    public boolean hasBlockState() {
        return !this.blockEntityTag.isEmpty() || !this.components.isEmpty();
    }

    public void clearBlockState() {
        this.blockEntityTag = CustomData.EMPTY;
        this.components = DataComponentMap.EMPTY;
    }

    public CraftBlockEntityState<?> getBlockState() {
        BlockPos pos = BlockPos.ZERO;
        Material stateMaterial = this.materialForBlockEntityType();
        if (!this.blockEntityTag.isEmpty()) {
            pos = BlockEntity.getPosFromTag(this.blockEntityTag.getUnsafe());
        }
        BlockEntityType<?> type = Objects.requireNonNull(CraftBlockStates.getBlockEntityType(stateMaterial));
        net.minecraft.world.level.block.state.BlockState nmsBlockState = ((CraftBlockData)this.getBlockData(stateMaterial)).getState();
        BlockEntity blockEntity = (BlockEntity)Objects.requireNonNull(type.create(pos, nmsBlockState));
        if (!this.blockEntityTag.isEmpty()) {
            this.blockEntityTag.loadInto(blockEntity, CraftRegistry.getMinecraftRegistry());
        }
        PatchedDataComponentMap patchedMap = new PatchedDataComponentMap(nmsBlockState.getBlock().asItem().components());
        patchedMap.setAll(this.components);
        CraftMetaItem.Applicator applicator = new CraftMetaItem.Applicator(this){};
        super.applyToItem(applicator);
        patchedMap.applyPatch(applicator.build());
        blockEntity.applyComponents(nmsBlockState.getBlock().asItem().components(), patchedMap.asPatch());
        return (CraftBlockEntityState)CraftBlockStates.getBlockState(null, pos, nmsBlockState, blockEntity);
    }

    private static CraftBlockEntityState<?> getBlockState(Material material, CompoundTag blockEntityTag) {
        Material stateMaterial;
        BlockPos pos = BlockPos.ZERO;
        Material material2 = stateMaterial = material != Material.SHIELD ? material : CraftMetaBlockState.shieldToBannerHack();
        if (blockEntityTag != null) {
            if (material == Material.SHIELD) {
                blockEntityTag.putString("id", "minecraft:banner");
            } else if (material == Material.BEE_NEST || material == Material.BEEHIVE) {
                blockEntityTag.putString("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(material)) {
                blockEntityTag.putString("id", "minecraft:shulker_box");
            }
            pos = BlockEntity.getPosFromTag(blockEntityTag);
        }
        return (CraftBlockEntityState)CraftBlockStates.getBlockState(pos, stateMaterial, blockEntityTag);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack();
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Preconditions.checkArgument((blockStateType == blockState.getClass() && blockState instanceof CraftBlockEntityState ? 1 : 0) != 0, (Object)("Invalid blockState for " + String.valueOf(this.material)));
        CraftBlockEntityState craftBlockState = (CraftBlockEntityState)blockState;
        CompoundTag data = craftBlockState.getSnapshotCustomNbtOnly();
        PatchedDataComponentMap patchedMap = new PatchedDataComponentMap(craftBlockState.getHandle().getBlock().asItem().components());
        DataComponentMap map = craftBlockState.collectComponents();
        patchedMap.setAll(map);
        if (!data.isEmpty()) {
            patchedMap.set(CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CustomData.of(data));
        }
        DataComponentPatch patch = patchedMap.asPatch();
        this.updateFromPatch(patch, null);
        this.blockEntityTag = CustomData.EMPTY;
        this.components = DataComponentMap.EMPTY;
        this.updateBlockState(patch);
    }

    private static Material shieldToBannerHack() {
        return Material.WHITE_BANNER;
    }
}

