/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.food.FoodProperties;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.potion.PotionEffect;

@SerializableAs(value="Food")
public final class CraftFoodComponent
implements FoodComponent {
    private FoodProperties handle;

    public CraftFoodComponent(FoodProperties food) {
        this.handle = food;
    }

    public CraftFoodComponent(CraftFoodComponent food) {
        this.handle = food.handle;
    }

    public CraftFoodComponent(Map<String, Object> map) {
        Integer nutrition = SerializableMeta.getObject(Integer.class, map, "nutrition", false);
        Float saturationModifier = SerializableMeta.getObject(Float.class, map, "saturation", false);
        Boolean canAlwaysEat = SerializableMeta.getBoolean(map, "can-always-eat");
        Float eatSeconds = SerializableMeta.getObject(Float.class, map, "eat-seconds", true);
        if (eatSeconds == null) {
            eatSeconds = Float.valueOf(1.6f);
        }
        ItemStack usingConvertsTo = SerializableMeta.getObject(ItemStack.class, map, "using-converts-to", true);
        ImmutableList.Builder effects = ImmutableList.builder();
        Iterable rawEffectList = SerializableMeta.getObject(Iterable.class, map, "effects", true);
        if (rawEffectList != null) {
            for (Object obj : rawEffectList) {
                Preconditions.checkArgument((boolean)(obj instanceof FoodComponent.FoodEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
                effects.add((Object)new CraftFoodEffect((FoodComponent.FoodEffect)obj));
            }
        }
        this.handle = new FoodProperties(nutrition, saturationModifier.floatValue(), canAlwaysEat, eatSeconds.floatValue(), Optional.ofNullable(usingConvertsTo).map(CraftItemStack::asNMSCopy), effects.build().stream().map(CraftFoodEffect::new).map(CraftFoodEffect::getHandle).toList());
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("nutrition", this.getNutrition());
        result.put("saturation", Float.valueOf(this.getSaturation()));
        result.put("can-always-eat", this.canAlwaysEat());
        result.put("eat-seconds", Float.valueOf(this.getEatSeconds()));
        result.put("using-converts-to", this.getUsingConvertsTo());
        result.put("effects", this.getEffects());
        return result;
    }

    public FoodProperties getHandle() {
        return this.handle;
    }

    public int getNutrition() {
        return this.handle.nutrition();
    }

    public void setNutrition(int nutrition) {
        Preconditions.checkArgument((nutrition >= 0 ? 1 : 0) != 0, (Object)"Nutrition cannot be negative");
        this.handle = new FoodProperties(nutrition, this.handle.saturation(), this.handle.canAlwaysEat(), this.handle.eatSeconds(), this.handle.usingConvertsTo(), this.handle.effects());
    }

    public float getSaturation() {
        return this.handle.saturation();
    }

    public void setSaturation(float saturation) {
        this.handle = new FoodProperties(this.handle.nutrition(), saturation, this.handle.canAlwaysEat(), this.handle.eatSeconds(), this.handle.usingConvertsTo(), this.handle.effects());
    }

    public boolean canAlwaysEat() {
        return this.handle.canAlwaysEat();
    }

    public void setCanAlwaysEat(boolean canAlwaysEat) {
        this.handle = new FoodProperties(this.handle.nutrition(), this.handle.saturation(), canAlwaysEat, this.handle.eatSeconds(), this.handle.usingConvertsTo(), this.handle.effects());
    }

    public float getEatSeconds() {
        return this.handle.eatSeconds();
    }

    public void setEatSeconds(float eatSeconds) {
        Preconditions.checkArgument((eatSeconds > 0.0f ? 1 : 0) != 0, (Object)"Eat seconds must be positive");
        this.handle = new FoodProperties(this.handle.nutrition(), this.handle.saturation(), this.handle.canAlwaysEat(), eatSeconds, this.handle.usingConvertsTo(), this.handle.effects());
    }

    public ItemStack getUsingConvertsTo() {
        return this.handle.usingConvertsTo().map(CraftItemStack::asBukkitCopy).orElse(null);
    }

    public void setUsingConvertsTo(ItemStack item) {
        Preconditions.checkArgument((item == null || !item.isEmpty() ? 1 : 0) != 0, (Object)"Item cannot be empty");
        this.handle = new FoodProperties(this.handle.nutrition(), this.handle.saturation(), this.handle.canAlwaysEat(), this.handle.eatSeconds(), Optional.ofNullable(item).map(CraftItemStack::asNMSCopy), this.handle.effects());
    }

    public List<FoodComponent.FoodEffect> getEffects() {
        return this.handle.effects().stream().map(CraftFoodEffect::new).collect(Collectors.toList());
    }

    public void setEffects(List<FoodComponent.FoodEffect> effects) {
        this.handle = new FoodProperties(this.handle.nutrition(), this.handle.saturation(), this.handle.canAlwaysEat(), this.handle.eatSeconds(), this.handle.usingConvertsTo(), effects.stream().map(CraftFoodEffect::new).map(CraftFoodEffect::getHandle).toList());
    }

    public FoodComponent.FoodEffect addEffect(PotionEffect effect, float probability) {
        Preconditions.checkArgument((0.0f <= probability && probability <= 1.0f ? 1 : 0) != 0, (Object)"Probability cannot be outside range [0,1]");
        ArrayList<FoodProperties.PossibleEffect> effects = new ArrayList<FoodProperties.PossibleEffect>(this.handle.effects());
        FoodProperties.PossibleEffect newEffect = new FoodProperties.PossibleEffect(CraftPotionUtil.fromBukkit(effect), probability);
        effects.add(newEffect);
        this.handle = new FoodProperties(this.handle.nutrition(), this.handle.saturation(), this.handle.canAlwaysEat(), this.handle.eatSeconds(), this.handle.usingConvertsTo(), effects);
        return new CraftFoodEffect(newEffect);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftFoodComponent other = (CraftFoodComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftFoodComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="FoodEffect")
    public static class CraftFoodEffect
    implements FoodComponent.FoodEffect {
        private FoodProperties.PossibleEffect handle;

        public CraftFoodEffect(FoodProperties.PossibleEffect handle) {
            this.handle = handle;
        }

        public CraftFoodEffect(FoodComponent.FoodEffect bukkit) {
            this.handle = new FoodProperties.PossibleEffect(CraftPotionUtil.fromBukkit(bukkit.getEffect()), bukkit.getProbability());
        }

        public CraftFoodEffect(Map<String, Object> map) {
            PotionEffect effect = SerializableMeta.getObject(PotionEffect.class, map, "effect", false);
            Float probability = SerializableMeta.getObject(Float.class, map, "probability", true);
            if (probability == null) {
                probability = Float.valueOf(1.0f);
            }
            this.handle = new FoodProperties.PossibleEffect(CraftPotionUtil.fromBukkit(effect), probability.floatValue());
        }

        public Map<String, Object> serialize() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("effect", this.getEffect());
            result.put("probability", Float.valueOf(this.getProbability()));
            return result;
        }

        public FoodProperties.PossibleEffect getHandle() {
            return this.handle;
        }

        public PotionEffect getEffect() {
            return CraftPotionUtil.toBukkit(this.handle.effect());
        }

        public void setEffect(PotionEffect effect) {
            this.handle = new FoodProperties.PossibleEffect(CraftPotionUtil.fromBukkit(effect), this.handle.probability());
        }

        public float getProbability() {
            return this.handle.probability();
        }

        public void setProbability(float probability) {
            Preconditions.checkArgument((0.0f <= probability && probability <= 1.0f ? 1 : 0) != 0, (Object)"Probability cannot be outside range [0,1]");
            this.handle = new FoodProperties.PossibleEffect(this.handle.effect(), probability);
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftFoodEffect other = (CraftFoodEffect)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftFoodEffect{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

