/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.spawner;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.spawner.Spawner;

public interface PaperSharedSpawnerLogic
extends Spawner {
    public BaseSpawner getSpawner();

    public Level getInternalWorld();

    public BlockPos getInternalPosition();

    default public boolean isActivated() {
        return this.getSpawner().isNearPlayer(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void resetTimer() {
        this.getSpawner().delay(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void setNextSpawnData(SpawnData spawnData) {
        this.getSpawner().setNextSpawnData(this.getInternalWorld(), this.getInternalPosition(), spawnData);
    }

    default public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        CompoundTag entity = new CompoundTag();
        entity.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(EntityType.ITEM).toString());
        entity.put("Item", item.save(this.getInternalWorld().registryAccess()));
        this.setNextSpawnData(new SpawnData(entity, Optional.empty(), Optional.ofNullable(this.getSpawner().nextSpawnData).flatMap(SpawnData::equipment)));
    }
}

