/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.lib.folialib;

import com.rylinaux.lib.folialib.enums.ImplementationType;
import com.rylinaux.lib.folialib.impl.FoliaImplementation;
import com.rylinaux.lib.folialib.impl.PaperImplementation;
import com.rylinaux.lib.folialib.impl.ServerImplementation;
import com.rylinaux.lib.folialib.impl.SpigotImplementation;
import com.rylinaux.lib.folialib.impl.UnsupportedImplementation;
import org.bukkit.plugin.java.JavaPlugin;

public class FoliaLib {
    private final JavaPlugin plugin;
    private final ImplementationType implementationType;
    private final ServerImplementation implementation;

    public FoliaLib(JavaPlugin plugin) {
        this.plugin = plugin;
        ImplementationType foundType = ImplementationType.UNKNOWN;
        block7: for (ImplementationType type : ImplementationType.values()) {
            String[] classNames;
            for (String className : classNames = type.getClassNames()) {
                try {
                    Class.forName(className);
                    foundType = type;
                    break block7;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        this.implementationType = foundType;
        switch (foundType) {
            case FOLIA: {
                this.implementation = new FoliaImplementation(this);
                break;
            }
            case PAPER: {
                this.implementation = new PaperImplementation(this);
                break;
            }
            case SPIGOT: {
                this.implementation = new SpigotImplementation(this);
                break;
            }
            default: {
                this.implementation = new UnsupportedImplementation(this);
            }
        }
    }

    public ImplementationType getImplType() {
        return this.implementationType;
    }

    public ServerImplementation getImpl() {
        return this.implementation;
    }

    public boolean isFolia() {
        return this.implementationType == ImplementationType.FOLIA;
    }

    public boolean isPaper() {
        return this.implementationType == ImplementationType.PAPER;
    }

    public boolean isSpigot() {
        return this.implementationType == ImplementationType.SPIGOT;
    }

    public boolean isUnsupported() {
        return this.implementationType == ImplementationType.UNKNOWN;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

