/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman;

import com.rylinaux.plugman.PlugMan;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;

public class PlugManTabCompleter
implements TabCompleter {
    private static final String[] COMMANDS = new String[]{"check", "disable", "dump", "enable", "help", "info", "list", "load", "lookup", "reload", "restart", "unload", "usage"};

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (sender.isOp() || sender.hasPermission("plugman.admin") || sender.hasPermission("plugman." + args[0])) {
            List<String> commands;
            String partialCommand;
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1) {
                partialCommand = args[0];
                commands = new ArrayList<String>(Arrays.asList(COMMANDS));
                StringUtil.copyPartialMatches((String)partialCommand, commands, completions);
            }
            if (args.length == 2) {
                List<String> plugins;
                String partialPlugin;
                if (args[0].equalsIgnoreCase("load")) {
                    ArrayList<String> files = new ArrayList<String>();
                    String partialPlugin2 = args[1];
                    for (File pluginFile : new File("plugins").listFiles()) {
                        try {
                            InputStream stream;
                            if (pluginFile.isDirectory() || !pluginFile.getName().toLowerCase().endsWith(".jar") && !new File("plugins", pluginFile.getName() + ".jar").exists()) continue;
                            JarFile jarFile = null;
                            try {
                                jarFile = new JarFile(pluginFile);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                continue;
                            }
                            if (jarFile.getEntry("plugin.yml") == null) continue;
                            try {
                                stream = jarFile.getInputStream(jarFile.getEntry("plugin.yml"));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                continue;
                            }
                            if (stream == null) continue;
                            PluginDescriptionFile descriptionFile = null;
                            try {
                                descriptionFile = new PluginDescriptionFile(stream);
                            }
                            catch (InvalidDescriptionException e) {
                                e.printStackTrace();
                                continue;
                            }
                            files.add(pluginFile.getName().substring(0, pluginFile.getName().length() - ".jar".length()));
                            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                                if (!plugin.getName().equalsIgnoreCase(descriptionFile.getName())) continue;
                                files.remove(pluginFile.getName().substring(0, pluginFile.getName().length() - ".jar".length()));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    StringUtil.copyPartialMatches((String)partialPlugin2, files, completions);
                } else if (args[0].equalsIgnoreCase("lookup")) {
                    partialCommand = args[1];
                    commands = PlugMan.getInstance().getPluginUtil().getKnownCommands().keySet().stream().filter(s -> !s.toLowerCase().contains(":")).collect(Collectors.toList());
                    commands.remove("/");
                    StringUtil.copyPartialMatches((String)partialCommand, commands, completions);
                } else if (args[0].equalsIgnoreCase("enable")) {
                    partialPlugin = args[1];
                    plugins = PlugMan.getInstance().getPluginUtil().getDisabledPluginNames(false);
                    StringUtil.copyPartialMatches((String)partialPlugin, plugins, completions);
                } else if (args[0].equalsIgnoreCase("disable")) {
                    partialPlugin = args[1];
                    plugins = PlugMan.getInstance().getPluginUtil().getEnabledPluginNames(false);
                    StringUtil.copyPartialMatches((String)partialPlugin, plugins, completions);
                } else {
                    partialPlugin = args[1];
                    plugins = PlugMan.getInstance().getPluginUtil().getPluginNames(false);
                    StringUtil.copyPartialMatches((String)partialPlugin, plugins, completions);
                }
            }
            Collections.sort(completions);
            return completions;
        }
        return null;
    }
}

