/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import com.rylinaux.plugman.pojo.UpdateResult;
import com.rylinaux.plugman.util.FlagUtil;
import com.rylinaux.plugman.util.StringUtil;
import com.rylinaux.plugman.util.ThreadUtil;
import com.rylinaux.plugman.util.UpdateUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CheckCommand
extends AbstractCommand {
    public static final String NAME = "Check";
    public static final String DESCRIPTION = "Check if a plugin is up-to-date.";
    public static final String PERMISSION = "plugman.check";
    public static final String USAGE = "/plugman check <plugin>";
    public static final String[] SUB_PERMISSIONS = new String[]{"all"};

    public CheckCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        boolean toFile = FlagUtil.hasFlag(args, 'f');
        if (args[1] == null) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (args[1].equalsIgnoreCase("all") || args[1].equalsIgnoreCase("*")) {
            if (!this.hasPermission("all")) {
                sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
                return;
            }
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.header", new Object[0]));
            ThreadUtil.async(() -> {
                Map<String, UpdateResult> results = UpdateUtil.checkUpToDate();
                StringBuilder upToDate = new StringBuilder();
                StringBuilder outOfDate = new StringBuilder();
                StringBuilder unknown = new StringBuilder();
                for (Map.Entry<String, UpdateResult> entry : results.entrySet()) {
                    UpdateResult.ResultType result = entry.getValue().getType();
                    String currentVersion = Bukkit.getPluginManager().getPlugin(entry.getKey()).getDescription().getVersion();
                    if (result == UpdateResult.ResultType.UP_TO_DATE) {
                        upToDate.append(entry.getKey()).append("(").append(currentVersion).append(") ");
                        continue;
                    }
                    if (result == UpdateResult.ResultType.INVALID_PLUGIN || result == UpdateResult.ResultType.NOT_INSTALLED) {
                        unknown.append(entry.getKey()).append("(").append(currentVersion).append(") ");
                        continue;
                    }
                    outOfDate.append(entry.getKey()).append("(").append(currentVersion).append(" -> ").append(entry.getValue().getLatestVersion()).append(") ");
                }
                if (!toFile) {
                    ThreadUtil.sync(() -> {
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.up-to-date-player", upToDate.toString()));
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.out-of-date-player", outOfDate.toString()));
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.unknown-player", unknown.toString()));
                    });
                    return;
                }
                File outFile = new File(PlugMan.getInstance().getDataFolder(), "updates.txt");
                try (PrintWriter writer = new PrintWriter(outFile);){
                    writer.println("Up-to-date (Installed):");
                    writer.println(upToDate);
                    writer.println("Out-of-date (Installed -> Latest):");
                    writer.println(outOfDate);
                    writer.println("Unknown (Installed):");
                    writer.println(unknown);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.file-done", outFile.getPath()));
            });
            return;
        }
        String pluginName = StringUtil.consolidateStrings(args, 1).replaceAll(" ", "+").replace("-[a-zA-Z]", "").replace("+null", "");
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.header", new Object[0]));
        ThreadUtil.async(() -> {
            UpdateResult result = UpdateUtil.checkUpToDate(pluginName);
            ThreadUtil.sync(() -> {
                switch (result.getType()) {
                    case NOT_INSTALLED: {
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.not-found", result.getLatestVersion()));
                        break;
                    }
                    case OUT_OF_DATE: {
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.out-of-date", result.getCurrentVersion(), result.getLatestVersion()));
                        break;
                    }
                    case UP_TO_DATE: {
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.up-to-date", result.getCurrentVersion()));
                        break;
                    }
                    default: {
                        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("check.not-found-spigot", new Object[0]));
                    }
                }
            });
        });
    }
}

