/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class EnableCommand
extends AbstractCommand {
    public static final String NAME = "Enable";
    public static final String DESCRIPTION = "Enable a plugin.";
    public static final String PERMISSION = "plugman.enable";
    public static final String USAGE = "/plugman enable <plugin|all>";
    public static final String[] SUB_PERMISSIONS = new String[]{"all"};

    public EnableCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (args[1].equalsIgnoreCase("all") || args[1].equalsIgnoreCase("*")) {
            if (!this.hasPermission("all")) {
                sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
                return;
            }
            PlugMan.getInstance().getPluginUtil().enableAll();
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("enable.all", new Object[0]));
            return;
        }
        Plugin target = PlugMan.getInstance().getPluginUtil().getPluginByName(args, 1);
        if (target == null) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.invalid-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (PlugMan.getInstance().getPluginUtil().isIgnored(target)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.ignored", new Object[0]));
            return;
        }
        if (PlugMan.getInstance().getPluginUtil().isPaperPlugin(target)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.paper-plugin", new Object[0]));
            return;
        }
        if (target.isEnabled()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("enable.already-enabled", target.getName()));
            return;
        }
        PlugMan.getInstance().getPluginUtil().enable(target);
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("enable.enabled", target.getName()));
    }
}

