/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.google.common.base.Joiner;
import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class InfoCommand
extends AbstractCommand {
    public static final String NAME = "Info";
    public static final String DESCRIPTION = "View information on a plugin.";
    public static final String PERMISSION = "plugman.info";
    public static final String USAGE = "/plugman info <plugin>";
    public static final String[] SUB_PERMISSIONS = new String[]{""};

    public InfoCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        Plugin target = PlugMan.getInstance().getPluginUtil().getPluginByName(args, 1);
        if (target == null) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.invalid-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        String name = target.getName();
        String version = target.getDescription().getVersion();
        String authors = Joiner.on((String)", ").join((Iterable)target.getDescription().getAuthors());
        String status = target.isEnabled() ? ChatColor.GREEN + "Enabled" : ChatColor.RED + "Disabled";
        List dependList = target.getDescription().getDepend();
        List softdependList = target.getDescription().getSoftDepend();
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("info.header", name));
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "info.version", version));
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "info.authors", authors));
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "info.status", status));
        if (!dependList.isEmpty()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "info.depends", Joiner.on((String)", ").join((Iterable)dependList)));
        }
        if (!softdependList.isEmpty()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "info.softdepends", Joiner.on((String)", ").join((Iterable)softdependList)));
        }
    }
}

