/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ReloadCommand
extends AbstractCommand {
    public static final String NAME = "Reload";
    public static final String DESCRIPTION = "Reload a plugin.";
    public static final String PERMISSION = "plugman.reload";
    public static final String USAGE = "/plugman reload <plugin|all>";
    public static final String[] SUB_PERMISSIONS = new String[]{"all"};

    public ReloadCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (args[1].equalsIgnoreCase("all") || args[1].equalsIgnoreCase("*")) {
            if (!this.hasPermission("all")) {
                sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
                return;
            }
            PlugMan.getInstance().getPluginUtil().reloadAll();
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("reload.all", new Object[0]));
            return;
        }
        Plugin target = PlugMan.getInstance().getPluginUtil().getPluginByName(args, 1);
        if (target == null) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.invalid-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (PlugMan.getInstance().getPluginUtil().isIgnored(target)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.ignored", new Object[0]));
            return;
        }
        if (PlugMan.getInstance().getPluginUtil().isPaperPlugin(target)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.paper-plugin", new Object[0]));
            return;
        }
        PlugMan.getInstance().getPluginUtil().reload(target);
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("reload.reloaded", target.getName()));
    }
}

