/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.pluginmanager;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.api.GentleUnload;
import com.rylinaux.plugman.api.PlugManAPI;
import com.rylinaux.plugman.pluginmanager.PluginManager;
import com.rylinaux.plugman.util.BukkitCommandWrap;
import com.rylinaux.plugman.util.BukkitCommandWrapUseless;
import com.rylinaux.plugman.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPluginManager
implements PluginManager {
    private final Class<?> pluginClassLoader;
    private final Field pluginClassLoaderPlugin;
    private Field commandMapField;
    private Field knownCommandsField;
    private final String nmsVersion;

    public BukkitPluginManager() {
        this.nmsVersion = null;
        try {
            this.pluginClassLoader = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            this.pluginClassLoaderPlugin = this.pluginClassLoader.getDeclaredField("plugin");
            this.pluginClassLoaderPlugin.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void enable(Plugin plugin) {
        if (plugin != null && !plugin.isEnabled()) {
            Bukkit.getPluginManager().enablePlugin(plugin);
        }
    }

    @Override
    public void enableAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (this.isIgnored(plugin) || this.isPaperPlugin(plugin)) continue;
            this.enable(plugin);
        }
    }

    @Override
    public void disable(Plugin plugin) {
        if (plugin != null && plugin.isEnabled()) {
            Bukkit.getPluginManager().disablePlugin(plugin);
        }
    }

    @Override
    public void disableAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (this.isIgnored(plugin) || this.isPaperPlugin(plugin)) continue;
            this.disable(plugin);
        }
    }

    @Override
    public String getFormattedName(Plugin plugin) {
        return this.getFormattedName(plugin, false);
    }

    @Override
    public String getFormattedName(Plugin plugin, boolean includeVersions) {
        ChatColor color = plugin.isEnabled() ? ChatColor.GREEN : ChatColor.RED;
        String pluginName = color + plugin.getName();
        if (includeVersions) {
            pluginName = pluginName + " (" + plugin.getDescription().getVersion() + ")";
        }
        return pluginName;
    }

    @Override
    public Plugin getPluginByName(String[] args, int start) {
        return this.getPluginByName(StringUtil.consolidateStrings(args, start));
    }

    @Override
    public Plugin getPluginByName(String name) {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!name.equalsIgnoreCase(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public List<String> getPluginNames(boolean fullName) {
        ArrayList<String> plugins = new ArrayList<String>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            plugins.add(fullName ? plugin.getDescription().getFullName() : plugin.getName());
        }
        return plugins;
    }

    @Override
    public List<String> getDisabledPluginNames(boolean fullName) {
        ArrayList<String> plugins = new ArrayList<String>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (plugin.isEnabled()) continue;
            plugins.add(fullName ? plugin.getDescription().getFullName() : plugin.getName());
        }
        return plugins;
    }

    @Override
    public List<String> getEnabledPluginNames(boolean fullName) {
        ArrayList<String> plugins = new ArrayList<String>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!plugin.isEnabled()) continue;
            plugins.add(fullName ? plugin.getDescription().getFullName() : plugin.getName());
        }
        return plugins;
    }

    @Override
    public String getPluginVersion(String name) {
        Plugin plugin = this.getPluginByName(name);
        if (plugin != null && plugin.getDescription() != null) {
            return plugin.getDescription().getVersion();
        }
        return null;
    }

    @Override
    public String getUsages(Plugin plugin) {
        String parsedCommands = this.getCommandsFromPlugin(plugin).stream().map(s -> {
            String[] parts = ((String)s.getKey()).split(":");
            return parts.length == 1 ? parts[0] : parts[1];
        }).collect(Collectors.joining(", "));
        if (parsedCommands.isEmpty()) {
            return "No commands registered.";
        }
        return parsedCommands;
    }

    private List<Map.Entry<String, Command>> getCommandsFromPlugin(Plugin plugin) {
        Map<String, Command> knownCommands = this.getKnownCommands();
        return knownCommands.entrySet().stream().filter(s -> {
            if (((String)s.getKey()).contains(":")) {
                return ((String)s.getKey()).split(":")[0].equalsIgnoreCase(plugin.getName());
            }
            ClassLoader cl = ((Command)s.getValue()).getClass().getClassLoader();
            try {
                return cl.getClass() == this.pluginClassLoader && this.pluginClassLoaderPlugin.get(cl) == plugin;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> findByCommand(String command) {
        ArrayList<String> plugins = new ArrayList<String>();
        for (Map.Entry<String, Command> s : this.getKnownCommands().entrySet()) {
            String[] parts;
            ClassLoader cl = s.getValue().getClass().getClassLoader();
            if (cl.getClass() != this.pluginClassLoader) {
                Plugin plugin;
                parts = s.getKey().split(":");
                if (parts.length != 2 || !parts[1].equalsIgnoreCase(command) || (plugin = (Plugin)Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(pl -> pl.getName().equalsIgnoreCase(parts[0])).findFirst().orElse(null)) == null) continue;
                plugins.add(plugin.getName());
                continue;
            }
            try {
                JavaPlugin plugin;
                parts = s.getKey().split(":");
                String cmd = parts[parts.length - 1];
                if (!cmd.equalsIgnoreCase(command) || plugins.contains((plugin = (JavaPlugin)this.pluginClassLoaderPlugin.get(cl)).getName())) continue;
                plugins.add(plugin.getName());
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return plugins;
    }

    @Override
    public boolean isIgnored(Plugin plugin) {
        return this.isIgnored(plugin.getName());
    }

    @Override
    public boolean isIgnored(String plugin) {
        for (String name : PlugMan.getInstance().getIgnoredPlugins()) {
            if (!name.equalsIgnoreCase(plugin)) continue;
            return true;
        }
        return false;
    }

    private String load(Plugin plugin) {
        return this.load(plugin.getName());
    }

    @Override
    public String load(String name) {
        Plugin target;
        File pluginDir = new File("plugins");
        if (!pluginDir.isDirectory()) {
            return PlugMan.getInstance().getMessageFormatter().format("load.plugin-directory", new Object[0]);
        }
        File pluginFile = new File(pluginDir, name + ".jar");
        if (!pluginFile.isFile()) {
            for (File f : pluginDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginDescriptionFile desc = PlugMan.getInstance().getPluginLoader().getPluginDescription(f);
                    if (!desc.getName().equalsIgnoreCase(name)) continue;
                    pluginFile = f;
                    break;
                }
                catch (InvalidDescriptionException e) {
                    return PlugMan.getInstance().getMessageFormatter().format("load.cannot-find", new Object[0]);
                }
            }
        }
        try {
            target = Bukkit.getPluginManager().loadPlugin(pluginFile);
        }
        catch (InvalidDescriptionException e) {
            e.printStackTrace();
            return PlugMan.getInstance().getMessageFormatter().format("load.invalid-description", new Object[0]);
        }
        catch (InvalidPluginException e) {
            e.printStackTrace();
            return PlugMan.getInstance().getMessageFormatter().format("load.invalid-plugin", new Object[0]);
        }
        target.onLoad();
        Bukkit.getPluginManager().enablePlugin(target);
        if (!(PlugMan.getInstance().getBukkitCommandWrap() instanceof BukkitCommandWrapUseless)) {
            Plugin finalTarget = target;
            Bukkit.getScheduler().runTaskLater((Plugin)PlugMan.getInstance(), () -> this.loadCommands(finalTarget), 10L);
            PlugMan.getInstance().getFilePluginMap().put(pluginFile.getName(), target.getName());
        }
        return PlugMan.getInstance().getMessageFormatter().format("load.loaded", target.getName());
    }

    @Override
    public Map<String, Command> getKnownCommands() {
        Map knownCommands;
        SimpleCommandMap commandMap;
        if (!this.fetchCommandMapField()) {
            throw new RuntimeException("Cannot find command map");
        }
        try {
            commandMap = (SimpleCommandMap)this.commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (!this.fetchKnownCommandsField()) {
            throw new RuntimeException("Unable to find known commands");
        }
        try {
            knownCommands = (Map)this.knownCommandsField.get(commandMap);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        return knownCommands;
    }

    private boolean fetchCommandMapField() {
        if (this.commandMapField != null) {
            return true;
        }
        try {
            this.commandMapField = Class.forName(BukkitCommandWrap.getCraftBukkitPrefix("CraftServer")).getDeclaredField("commandMap");
            this.commandMapField.setAccessible(true);
            return true;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean fetchKnownCommandsField() {
        if (this.knownCommandsField != null) {
            return true;
        }
        try {
            this.knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            this.knownCommandsField.setAccessible(true);
            return true;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setKnownCommands(Map<String, Command> knownCommands) {
        SimpleCommandMap commandMap;
        if (!this.fetchCommandMapField()) {
            throw new RuntimeException("Cannot find command map");
        }
        try {
            commandMap = (SimpleCommandMap)this.commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (!this.fetchKnownCommandsField()) {
            throw new RuntimeException("Unable to find known commands");
        }
        try {
            this.knownCommandsField.set(commandMap, knownCommands);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload(Plugin plugin) {
        if (plugin != null) {
            this.unload(plugin);
            this.load(plugin);
        }
    }

    @Override
    public void reloadAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (this.isIgnored(plugin) || this.isPaperPlugin(plugin)) continue;
            this.reload(plugin);
        }
    }

    @Override
    public synchronized String unload(Plugin plugin) {
        ClassLoader cl;
        String name = plugin.getName();
        if (PlugManAPI.getGentleUnloads().containsKey(plugin)) {
            GentleUnload gentleUnload = PlugManAPI.getGentleUnloads().get(plugin);
            if (!gentleUnload.askingForGentleUnload()) {
                return name + "did not want to unload";
            }
        } else {
            if (!(PlugMan.getInstance().getBukkitCommandWrap() instanceof BukkitCommandWrapUseless)) {
                this.unloadCommands(plugin);
            }
            org.bukkit.plugin.PluginManager pluginManager = Bukkit.getPluginManager();
            SimpleCommandMap commandMap = null;
            List plugins = null;
            Map names = null;
            Map commands = null;
            Map listeners = null;
            boolean reloadlisteners = true;
            if (pluginManager != null) {
                pluginManager.disablePlugin(plugin);
                try {
                    Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                    pluginsField.setAccessible(true);
                    plugins = (List)pluginsField.get(pluginManager);
                    Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                    lookupNamesField.setAccessible(true);
                    names = (Map)lookupNamesField.get(pluginManager);
                    try {
                        Field field = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                        field.setAccessible(true);
                        listeners = (Map)field.get(pluginManager);
                    }
                    catch (Exception exception) {
                        reloadlisteners = false;
                    }
                    Field field = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                    field.setAccessible(true);
                    commandMap = (SimpleCommandMap)field.get(pluginManager);
                    Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                    knownCommandsField.setAccessible(true);
                    commands = (Map)knownCommandsField.get(commandMap);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    return PlugMan.getInstance().getMessageFormatter().format("unload.failed", name);
                }
            }
            pluginManager.disablePlugin(plugin);
            if (listeners != null && reloadlisteners) {
                for (SortedSet set : listeners.values()) {
                    set.removeIf(value -> value.getPlugin() == plugin);
                }
            }
            if (commandMap != null) {
                HashMap<String, Command> modifiedKnownCommands = new HashMap<String, Command>(commands);
                for (Map.Entry<String, Command> entry : new HashMap(commands).entrySet()) {
                    if (entry.getValue() instanceof PluginCommand) {
                        PluginCommand c = (PluginCommand)entry.getValue();
                        if (c.getPlugin() != plugin) continue;
                        c.unregister(commandMap);
                        modifiedKnownCommands.remove(entry.getKey());
                        continue;
                    }
                    try {
                        this.unregisterNonPluginCommands(plugin, (CommandMap)commandMap, (Map<String, Command>)modifiedKnownCommands, entry);
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().equalsIgnoreCase("zip file closed")) continue;
                        if (PlugMan.getInstance().isNotifyOnBrokenCommandRemoval()) {
                            Logger.getLogger(BukkitPluginManager.class.getName()).info("Removing broken command '" + entry.getValue().getName() + "'!");
                        }
                        entry.getValue().unregister(commandMap);
                        modifiedKnownCommands.remove(entry.getKey());
                    }
                }
                this.setKnownCommands(modifiedKnownCommands);
            }
            if (plugins != null) {
                plugins.remove(plugin);
            }
            if (names != null) {
                names.remove(name);
            }
        }
        if ((cl = plugin.getClass().getClassLoader()) instanceof URLClassLoader) {
            try {
                Field pluginField = cl.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                pluginField.set(cl, null);
                Field pluginInitField = cl.getClass().getDeclaredField("pluginInit");
                pluginInitField.setAccessible(true);
                pluginInitField.set(cl, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(BukkitPluginManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                Logger.getLogger(BukkitPluginManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.gc();
        return PlugMan.getInstance().getMessageFormatter().format("unload.unloaded", name);
    }

    protected void unregisterNonPluginCommands(Plugin plugin, CommandMap commandMap, Map<String, Command> commands, Map.Entry<String, Command> entry) {
        Field pluginField = Arrays.stream(entry.getValue().getClass().getDeclaredFields()).filter(field -> Plugin.class.isAssignableFrom(field.getType())).findFirst().orElse(null);
        if (pluginField == null) {
            return;
        }
        try {
            pluginField.setAccessible(true);
            Plugin owningPlugin = (Plugin)pluginField.get(entry.getValue());
            if (owningPlugin.getName().equalsIgnoreCase(plugin.getName())) {
                entry.getValue().unregister(commandMap);
                commands.remove(entry.getKey());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isPaperPlugin(Plugin plugin) {
        return false;
    }

    protected void loadCommands(Plugin plugin) {
        List<Map.Entry<String, Command>> commands = this.getCommandsFromPlugin(plugin);
        for (Map.Entry<String, Command> entry : commands) {
            String alias = entry.getKey();
            Command command = entry.getValue();
            PlugMan.getInstance().getBukkitCommandWrap().wrap(command, alias);
        }
        PlugMan.getInstance().getBukkitCommandWrap().sync();
    }

    protected synchronized void unloadCommands(Plugin plugin) {
        String alias;
        Map<String, Command> knownCommands = this.getKnownCommands();
        List<Map.Entry<String, Command>> commands = this.getCommandsFromPlugin(plugin);
        for (Map.Entry<String, Command> entry : commands) {
            alias = entry.getKey();
            PlugMan.getInstance().getBukkitCommandWrap().unwrap(alias);
        }
        for (Map.Entry<String, Object> entry : knownCommands.entrySet().stream().filter(stringCommandEntry -> Plugin.class.isAssignableFrom(((Command)stringCommandEntry.getValue()).getClass())).filter(stringCommandEntry -> {
            Field pluginField = Arrays.stream(((Command)stringCommandEntry.getValue()).getClass().getDeclaredFields()).filter(field -> Plugin.class.isAssignableFrom(field.getType())).findFirst().orElse(null);
            if (pluginField != null) {
                try {
                    Plugin owningPlugin = (Plugin)pluginField.get(stringCommandEntry.getValue());
                    return owningPlugin.getName().equalsIgnoreCase(plugin.getName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }).collect(Collectors.toList())) {
            alias = entry.getKey();
            PlugMan.getInstance().getBukkitCommandWrap().unwrap(alias);
        }
        PlugMan.getInstance().getBukkitCommandWrap().sync();
    }
}

