/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.pluginmanager;

import com.rylinaux.lib.folialib.FoliaLib;
import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.api.GentleUnload;
import com.rylinaux.plugman.api.PlugManAPI;
import com.rylinaux.plugman.pluginmanager.BukkitPluginManager;
import com.rylinaux.plugman.pluginmanager.PluginManager;
import com.rylinaux.plugman.util.BukkitCommandWrapUseless;
import com.rylinaux.plugman.util.StringUtil;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.yaml.snakeyaml.error.YAMLException;

public class PaperPluginManager
implements PluginManager {
    private final BukkitPluginManager _bukkitPluginManager;

    public PaperPluginManager(BukkitPluginManager bukkitPluginManager) {
        this._bukkitPluginManager = bukkitPluginManager;
        try {
            Class<?> pluginClassLoader = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            Field pluginClassLoaderPlugin = pluginClassLoader.getDeclaredField("plugin");
            pluginClassLoaderPlugin.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPaperPlugin(Plugin plugin) {
        try {
            Field instanceField = Class.forName("io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler").getField("INSTANCE");
            instanceField.setAccessible(true);
            Object instance = instanceField.get(null);
            Method getMethod = Arrays.stream(instance.getClass().getDeclaredMethods()).filter(method -> method.getName().equals("get")).findFirst().orElse(null);
            if (getMethod == null) {
                return false;
            }
            Field pluginField = Class.forName("io.papermc.paper.plugin.entrypoint.Entrypoint").getDeclaredField("PLUGIN");
            Object providerStorage = getMethod.invoke(instance, pluginField.get(null));
            if (providerStorage == null) {
                return false;
            }
            Method getRegisteredProvidersMethod = providerStorage.getClass().getMethod("getRegisteredProviders", new Class[0]);
            List providers = (List)getRegisteredProvidersMethod.invoke(providerStorage, new Object[0]);
            for (Object provider : providers) {
                try {
                    Method getMetaMethod = provider.getClass().getMethod("getMeta", new Class[0]);
                    PluginMeta configuration = (PluginMeta)getMetaMethod.invoke(provider, new Object[0]);
                    if (!configuration.getName().equalsIgnoreCase(plugin.getName())) continue;
                    return Class.forName("io.papermc.paper.plugin.provider.type.paper.PaperPluginParent$PaperServerPluginProvider").isAssignableFrom(provider.getClass());
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    @Override
    public void enable(Plugin plugin) {
        this._bukkitPluginManager.enable(plugin);
    }

    @Override
    public void enableAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (this.isIgnored(plugin) || this.isPaperPlugin(plugin)) continue;
            this.enable(plugin);
        }
    }

    @Override
    public void disable(Plugin plugin) {
        this._bukkitPluginManager.disable(plugin);
    }

    @Override
    public void disableAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (this.isIgnored(plugin) || this.isPaperPlugin(plugin)) continue;
            this.disable(plugin);
        }
    }

    @Override
    public String getFormattedName(Plugin plugin) {
        return this.getFormattedName(plugin, false);
    }

    @Override
    public String getFormattedName(Plugin plugin, boolean includeVersions) {
        return this._bukkitPluginManager.getFormattedName(plugin, includeVersions);
    }

    @Override
    public Plugin getPluginByName(String[] args, int start) {
        return this.getPluginByName(StringUtil.consolidateStrings(args, start));
    }

    @Override
    public Plugin getPluginByName(String name) {
        return this._bukkitPluginManager.getPluginByName(name);
    }

    @Override
    public List<String> getPluginNames(boolean fullName) {
        return this._bukkitPluginManager.getPluginNames(fullName);
    }

    @Override
    public List<String> getDisabledPluginNames(boolean fullName) {
        return this._bukkitPluginManager.getDisabledPluginNames(fullName);
    }

    @Override
    public List<String> getEnabledPluginNames(boolean fullName) {
        return this._bukkitPluginManager.getEnabledPluginNames(fullName);
    }

    @Override
    public String getPluginVersion(String name) {
        return this._bukkitPluginManager.getPluginVersion(name);
    }

    @Override
    public String getUsages(Plugin plugin) {
        return this._bukkitPluginManager.getUsages(plugin);
    }

    @Override
    public List<String> findByCommand(String command) {
        return this._bukkitPluginManager.findByCommand(command);
    }

    @Override
    public boolean isIgnored(Plugin plugin) {
        return this.isIgnored(plugin.getName());
    }

    @Override
    public boolean isIgnored(String plugin) {
        return this._bukkitPluginManager.isIgnored(plugin);
    }

    public PluginDescriptionFile getPluginDescription(File file) throws InvalidDescriptionException {
        if (file == null) {
            throw new InvalidDescriptionException("File cannot be null");
        }
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new InvalidDescriptionException((Throwable)new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(stream);
            return pluginDescriptionFile;
        }
        catch (IOException | YAMLException ex) {
            throw new InvalidDescriptionException(ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private String load(Plugin plugin) {
        return this.load(plugin.getName());
    }

    @Override
    public String load(String name) {
        Plugin target = null;
        boolean paperLoaded = false;
        File pluginDir = new File("plugins");
        if (!pluginDir.isDirectory()) {
            return PlugMan.getInstance().getMessageFormatter().format("load.plugin-directory", new Object[0]);
        }
        File pluginFile = new File(pluginDir, name + ".jar");
        if (!pluginFile.isFile()) {
            for (File f : pluginDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    PluginDescriptionFile desc = this.getPluginDescription(f);
                    if (!desc.getName().equalsIgnoreCase(name)) continue;
                    pluginFile = f;
                    break;
                }
                catch (InvalidDescriptionException e) {
                    return PlugMan.getInstance().getMessageFormatter().format("load.cannot-find", new Object[0]);
                }
            }
        }
        try {
            Class<?> paper = Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
            Object paperPluginManagerImpl = paper.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Field instanceManagerF = paperPluginManagerImpl.getClass().getDeclaredField("instanceManager");
            instanceManagerF.setAccessible(true);
            Object instanceManager = instanceManagerF.get(paperPluginManagerImpl);
            Method loadMethod = instanceManager.getClass().getMethod("loadPlugin", Path.class);
            loadMethod.setAccessible(true);
            target = (Plugin)loadMethod.invoke(instanceManager, pluginFile.toPath());
            Method enableMethod = instanceManager.getClass().getMethod("enablePlugin", Plugin.class);
            enableMethod.setAccessible(true);
            enableMethod.invoke(instanceManager, target);
            paperLoaded = true;
        }
        catch (Exception paper) {
            // empty catch block
        }
        if (!paperLoaded) {
            try {
                target = Bukkit.getPluginManager().loadPlugin(pluginFile);
            }
            catch (InvalidDescriptionException e) {
                e.printStackTrace();
                return PlugMan.getInstance().getMessageFormatter().format("load.invalid-description", new Object[0]);
            }
            catch (InvalidPluginException e) {
                e.printStackTrace();
                return PlugMan.getInstance().getMessageFormatter().format("load.invalid-plugin", new Object[0]);
            }
            target.onLoad();
            Bukkit.getPluginManager().enablePlugin(target);
        }
        if (!(PlugMan.getInstance().getBukkitCommandWrap() instanceof BukkitCommandWrapUseless)) {
            Plugin finalTarget = target;
            if (this.isFolia()) {
                FoliaLib foliaLib = new FoliaLib(PlugMan.getInstance());
                foliaLib.getImpl().runLater(() -> this.loadCommands(finalTarget), 500L, TimeUnit.MILLISECONDS);
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)PlugMan.getInstance(), () -> this.loadCommands(finalTarget), 10L);
            }
            PlugMan.getInstance().getFilePluginMap().put(pluginFile.getName(), target.getName());
        }
        return PlugMan.getInstance().getMessageFormatter().format("load.loaded", target.getName());
    }

    private void loadCommands(Plugin target) {
        this._bukkitPluginManager.loadCommands(target);
    }

    protected void unloadCommands(Plugin target) {
        this._bukkitPluginManager.unloadCommands(target);
    }

    @Override
    public Map<String, Command> getKnownCommands() {
        return this._bukkitPluginManager.getKnownCommands();
    }

    @Override
    public void setKnownCommands(Map<String, Command> knownCommands) {
        this._bukkitPluginManager.setKnownCommands(knownCommands);
    }

    @Override
    public void reload(Plugin plugin) {
        if (plugin != null) {
            this.unload(plugin);
            this.load(plugin);
        }
    }

    @Override
    public void reloadAll() {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (this.isIgnored(plugin) || this.isPaperPlugin(plugin)) continue;
            this.reload(plugin);
        }
    }

    @Override
    public String unload(Plugin plugin) {
        String name = plugin.getName();
        if (PlugManAPI.getGentleUnloads().containsKey(plugin)) {
            GentleUnload gentleUnload = PlugManAPI.getGentleUnloads().get(plugin);
            if (!gentleUnload.askingForGentleUnload()) {
                return name + "did not want to unload";
            }
        } else {
            if (!(PlugMan.getInstance().getBukkitCommandWrap() instanceof BukkitCommandWrapUseless)) {
                this.unloadCommands(plugin);
            }
            org.bukkit.plugin.PluginManager pluginManager = Bukkit.getPluginManager();
            SimpleCommandMap commandMap = null;
            List plugins = null;
            Map names = null;
            Map commands = null;
            Map listeners = null;
            boolean reloadlisteners = true;
            if (pluginManager != null) {
                pluginManager.disablePlugin(plugin);
                try {
                    Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
                    pluginsField.setAccessible(true);
                    plugins = (List)pluginsField.get(pluginManager);
                    Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
                    lookupNamesField.setAccessible(true);
                    names = (Map)lookupNamesField.get(pluginManager);
                    try {
                        Field field = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                        field.setAccessible(true);
                        listeners = (Map)field.get(pluginManager);
                    }
                    catch (Exception exception) {
                        reloadlisteners = false;
                    }
                    Field field = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                    field.setAccessible(true);
                    commandMap = (SimpleCommandMap)field.get(pluginManager);
                    Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                    knownCommandsField.setAccessible(true);
                    commands = (Map)knownCommandsField.get(commandMap);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    return PlugMan.getInstance().getMessageFormatter().format("unload.failed", name);
                }
            }
            pluginManager.disablePlugin(plugin);
            if (listeners != null && reloadlisteners) {
                for (Object set : listeners.values()) {
                    set.removeIf(value -> value.getPlugin() == plugin);
                }
            }
            if (commandMap != null) {
                HashMap<String, Command> modifiedKnownCommands = new HashMap<String, Command>(commands);
                for (Map.Entry entry : new HashMap(commands).entrySet()) {
                    if (entry.getValue() instanceof PluginCommand) {
                        PluginCommand c = (PluginCommand)entry.getValue();
                        if (c.getPlugin() != plugin) continue;
                        c.unregister(commandMap);
                        modifiedKnownCommands.remove(entry.getKey());
                        continue;
                    }
                    try {
                        this._bukkitPluginManager.unregisterNonPluginCommands(plugin, (CommandMap)commandMap, (Map<String, Command>)modifiedKnownCommands, entry);
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().equalsIgnoreCase("zip file closed")) continue;
                        if (PlugMan.getInstance().isNotifyOnBrokenCommandRemoval()) {
                            Logger.getLogger(PaperPluginManager.class.getName()).info("Removing broken command '" + ((Command)entry.getValue()).getName() + "'!");
                        }
                        ((Command)entry.getValue()).unregister(commandMap);
                        modifiedKnownCommands.remove(entry.getKey());
                    }
                }
                this.setKnownCommands(modifiedKnownCommands);
            }
            if (plugins != null) {
                plugins.remove(plugin);
            }
            if (names != null) {
                names.remove(name);
            }
        }
        this.closeClassLoader(plugin);
        try {
            Class<?> paper = Class.forName("io.papermc.paper.plugin.manager.PaperPluginManagerImpl");
            Object paperPluginManagerImpl = paper.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Field instanceManagerField = paperPluginManagerImpl.getClass().getDeclaredField("instanceManager");
            instanceManagerField.setAccessible(true);
            Object instanceManager = instanceManagerField.get(paperPluginManagerImpl);
            Field lookupNamesField = instanceManager.getClass().getDeclaredField("lookupNames");
            lookupNamesField.setAccessible(true);
            Map lookupNames = (Map)lookupNamesField.get(instanceManager);
            Method disableMethod = instanceManager.getClass().getMethod("disablePlugin", Plugin.class);
            disableMethod.setAccessible(true);
            disableMethod.invoke(instanceManager, plugin);
            lookupNames.remove(plugin.getName().toLowerCase());
            Field pluginListField = instanceManager.getClass().getDeclaredField("plugins");
            pluginListField.setAccessible(true);
            List pluginList = (List)pluginListField.get(instanceManager);
            pluginList.remove(plugin);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
        return PlugMan.getInstance().getMessageFormatter().format("unload.unloaded", name);
    }

    protected void closeClassLoader(Plugin plugin) {
        ClassLoader classLoader = plugin.getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            return;
        }
        try {
            Field pluginField = classLoader.getClass().getDeclaredField("plugin");
            pluginField.setAccessible(true);
            pluginField.set(classLoader, null);
            Field pluginInitField = classLoader.getClass().getDeclaredField("pluginInit");
            pluginInitField.setAccessible(true);
            pluginInitField.set(classLoader, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(PaperPluginManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            ((URLClassLoader)classLoader).close();
        }
        catch (IOException ex) {
            Logger.getLogger(PaperPluginManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

