/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.util;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.pojo.UpdateResult;
import com.rylinaux.plugman.util.CollectionUtil;
import com.rylinaux.plugman.util.CurseForgeUtil;
import com.rylinaux.plugman.util.SpiGetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;

public class UpdateUtil {
    private static final Pattern VERSION_FAMILY_NUMBERS_PATTERN = Pattern.compile("\\d+(\\.\\d+)*");

    public static Map<String, UpdateResult> checkUpToDate() {
        TreeMap<String, UpdateResult> results = new TreeMap<String, UpdateResult>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            results.put(plugin.getName(), UpdateUtil.checkUpToDate(plugin.getName()));
        }
        return results;
    }

    public static UpdateResult checkUpToDate(String pluginName) {
        if (PlugMan.getInstance().getResourceMap().containsKey(pluginName.toLowerCase(Locale.ROOT))) {
            Map.Entry<Long, Boolean> entry = PlugMan.getInstance().getResourceMap().get(pluginName.toLowerCase(Locale.ROOT));
            if (entry.getValue().booleanValue()) {
                return SpiGetUtil.checkUpToDate(pluginName, entry.getKey());
            }
            return CurseForgeUtil.checkUpToDate(pluginName, entry.getKey());
        }
        long id = SpiGetUtil.getPluginId(pluginName);
        if (id < 0L) {
            id = CurseForgeUtil.getPluginId(pluginName);
            if (id < 0L) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
                if (plugin == null) {
                    return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, pluginName);
                }
                return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, plugin.getDescription().getVersion());
            }
            return CurseForgeUtil.checkUpToDate(pluginName);
        }
        return SpiGetUtil.checkUpToDate(pluginName);
    }

    public static long getPluginId(String name) {
        if (PlugMan.getInstance().getResourceMap().containsKey(name.toLowerCase(Locale.ROOT))) {
            Map.Entry<Long, Boolean> entry = PlugMan.getInstance().getResourceMap().get(name.toLowerCase(Locale.ROOT));
            if (entry.getValue().booleanValue()) {
                return SpiGetUtil.getPluginId(name);
            }
            return CurseForgeUtil.getPluginId(name);
        }
        long id = SpiGetUtil.getPluginId(name);
        if (id < 0L) {
            id = CurseForgeUtil.getPluginId(name);
        }
        return id;
    }

    public static JSONArray getPluginVersions(long id) {
        for (Map.Entry<Long, Boolean> entry : PlugMan.getInstance().getResourceMap().values()) {
            if (entry.getKey() != id) continue;
            if (entry.getValue().booleanValue()) {
                return SpiGetUtil.getPluginVersions(id);
            }
            return CurseForgeUtil.getPluginVersions(id);
        }
        JSONArray jsonArray = SpiGetUtil.getPluginVersions(id);
        if (jsonArray == null || jsonArray.size() <= 0) {
            return CurseForgeUtil.getPluginVersions(id);
        }
        return jsonArray;
    }

    protected static Boolean isActualVersion(String current, String latest) {
        List<List<Integer>> latestNumbers;
        List<List<Integer>> currentNumbers;
        if (current.equalsIgnoreCase(latest)) {
            return true;
        }
        try {
            currentNumbers = UpdateUtil.parseNumbers(VERSION_FAMILY_NUMBERS_PATTERN.matcher(current));
            latestNumbers = UpdateUtil.parseNumbers(VERSION_FAMILY_NUMBERS_PATTERN.matcher(latest));
        }
        catch (NumberFormatException ex) {
            return null;
        }
        for (int familyIndex = 0; familyIndex < CollectionUtil.maxCollectionsSize(currentNumbers, latestNumbers); ++familyIndex) {
            List currentFamily = CollectionUtil.getElementOrDefault(currentNumbers, familyIndex, ArrayList::new);
            List latestFamily = CollectionUtil.getElementOrDefault(latestNumbers, familyIndex, ArrayList::new);
            for (int numberIndex = 0; numberIndex < CollectionUtil.maxCollectionsSize(currentFamily, latestFamily); ++numberIndex) {
                int currentValue = CollectionUtil.getElementOrDefault(currentFamily, numberIndex, () -> 0);
                int latestValue = CollectionUtil.getElementOrDefault(latestFamily, numberIndex, () -> 0);
                if (latestValue > currentValue) {
                    return false;
                }
                if (latestValue >= currentValue) continue;
                return true;
            }
        }
        return true;
    }

    private static List<List<Integer>> parseNumbers(Matcher matcher) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        while (matcher.find()) {
            String familyString = matcher.group();
            ArrayList<Integer> family = new ArrayList<Integer>();
            for (String number : familyString.split("\\.")) {
                family.add(Integer.parseInt(number));
            }
            result.add(family);
        }
        return result;
    }
}

