/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.plugmanbungee.commands.cmd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.entity303.plugmanbungee.util.BungeePluginUtil;
import me.entity303.plugmanbungee.util.PluginResult;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class LoadCommand {
    public void execute(CommandSender sender, String[] args) {
        if (args.length <= 0) {
            this.sendMessage(sender, "\u00a7cSyntax: \u00a74/PlugManBungee unload <File>");
            return;
        }
        String filename = args[0].replaceAll("[/\\\\]", "");
        File file = new File("plugins", filename + ".jar");
        if (!file.exists()) {
            this.sendMessage(sender, "\u00a7cThere is no plugin file named \u00a74" + filename + "\u00a7c!");
            return;
        }
        PluginResult pluginResult = BungeePluginUtil.loadPlugin(file);
        this.sendMessage(sender, pluginResult.getMessage());
    }

    private void sendMessage(CommandSender sender, String message) {
        sender.sendMessage((BaseComponent)new TextComponent("\u00a78[\u00a72PlugManBungee\u00a78] \u00a77" + message));
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            for (File file : new File("plugins").listFiles()) {
                if (!file.isFile() || !file.getName().toLowerCase(Locale.ROOT).endsWith(".jar")) continue;
                try (JarFile jar = new JarFile(file);){
                    JarEntry pdf = jar.getJarEntry("bungee.yml");
                    if (pdf == null) {
                        pdf = jar.getJarEntry("plugin.yml");
                    }
                    if (pdf == null) continue;
                    try (InputStream in = jar.getInputStream(pdf);){
                        Configuration cfg = ConfigurationProvider.getProvider(YamlConfiguration.class).load((Reader)new InputStreamReader(in));
                        if (cfg.get("name", null) == null || cfg.get("main", null) == null || ProxyServer.getInstance().getPluginManager().getPlugin(cfg.getString("name", null)) != null) continue;
                        completions.add(file.getName().substring(0, file.getName().length() - 4));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ArrayList<String> realCompletions = new ArrayList<String>();
            for (String com : completions) {
                if (!com.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))) continue;
                realCompletions.add(com);
            }
            return realCompletions.size() > 0 ? realCompletions : completions;
        }
        return new ArrayList<String>();
    }
}

