/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.plugmanbungee.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Handler;
import java.util.logging.Level;
import me.entity303.plugmanbungee.main.PlugManBungee;
import me.entity303.plugmanbungee.util.PluginResult;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.api.plugin.PluginManager;
import org.yaml.snakeyaml.Yaml;

public class BungeePluginUtil {
    public static Map.Entry<PluginResult, PluginResult> reloadPlugin(Plugin plugin) {
        File file = plugin.getFile();
        final PluginResult result1 = BungeePluginUtil.unloadPlugin(plugin);
        final PluginResult result2 = BungeePluginUtil.loadPlugin(file);
        return new Map.Entry<PluginResult, PluginResult>(){

            @Override
            public PluginResult getKey() {
                return result1;
            }

            @Override
            public PluginResult getValue() {
                return result2;
            }

            @Override
            public PluginResult setValue(PluginResult value) {
                return result2;
            }
        };
    }

    public static PluginResult unloadPlugin(Plugin plugin) {
        Map plugins;
        boolean exception = false;
        PluginManager pluginManager = ProxyServer.getInstance().getPluginManager();
        try {
            plugin.onDisable();
            for (Handler handler : plugin.getLogger().getHandlers()) {
                handler.close();
            }
        }
        catch (Throwable t) {
            PlugManBungee.getInstance().getLogger().log(Level.SEVERE, "Exception disabling plugin '" + plugin.getDescription().getName() + "'", t);
            exception = true;
        }
        pluginManager.unregisterCommands(plugin);
        pluginManager.unregisterListeners(plugin);
        ProxyServer.getInstance().getScheduler().cancel(plugin);
        plugin.getExecutorService().shutdownNow();
        Field pluginsField = null;
        try {
            pluginsField = PluginManager.class.getDeclaredField("plugins");
            pluginsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return new PluginResult("\u00a7cError while trying to unload plugin: \u00a74Could not load field 'plugins'\u00a7c, see console for more info!", false);
        }
        try {
            plugins = (Map)pluginsField.get(pluginManager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new PluginResult("\u00a7cError while trying to unload plugin: \u00a74Could not get field 'plugins'\u00a7c, see console for more info!", false);
        }
        plugins.remove(plugin.getDescription().getName());
        ClassLoader cl = plugin.getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            try {
                Field pluginField = cl.getClass().getDeclaredField("plugin");
                pluginField.setAccessible(true);
                pluginField.set(cl, null);
                Field pluginInitField = cl.getClass().getDeclaredField("desc");
                pluginInitField.setAccessible(true);
                pluginInitField.set(cl, null);
                Field allLoadersField = cl.getClass().getDeclaredField("allLoaders");
                allLoadersField.setAccessible(true);
                Set allLoaders = (Set)allLoadersField.get(cl);
                allLoaders.remove(cl);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                PlugManBungee.getInstance().getLogger().log(Level.SEVERE, null, ex);
                return new PluginResult("\u00a7cError while trying to unload plugin: \u00a74Could not unload ClassLoader\u00a7c, see console for more info!", false);
            }
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                PlugManBungee.getInstance().getLogger().log(Level.SEVERE, null, ex);
                return new PluginResult("\u00a7cError while trying to unload plugin: \u00a74Could not close ClassLoader\u00a7c, see console for more info!", false);
            }
        }
        System.gc();
        if (exception) {
            return new PluginResult("\u00a7cAn unknown error occured while unloading, see console for more info!", false);
        }
        return new PluginResult("\u00a77Plugin was unloaded successfully!", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginResult loadPlugin(File file) {
        PluginManager pluginManager = ProxyServer.getInstance().getPluginManager();
        Field yamlField = null;
        try {
            yamlField = PluginManager.class.getDeclaredField("yaml");
            yamlField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return new PluginResult("\u00a7cError while trying to load plugin: \u00a74Could not load field 'yaml'\u00a7c, see console for more info!", false);
        }
        Yaml yaml = null;
        try {
            yaml = (Yaml)yamlField.get(pluginManager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new PluginResult("\u00a7cError while trying to load plugin: \u00a74Could not get field 'yaml'\u00a7c, see console for more info!", false);
        }
        Field toLoadField = null;
        try {
            toLoadField = PluginManager.class.getDeclaredField("toLoad");
            toLoadField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return new PluginResult("\u00a7cError while trying to load plugin: \u00a74Could not load field 'toLoad'\u00a7c, see console for more info!", false);
        }
        HashMap<String, PluginDescription> toLoad = null;
        try {
            toLoad = (HashMap<String, PluginDescription>)toLoadField.get(pluginManager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new PluginResult("\u00a7cError while trying to load plugin: \u00a74Could not get field 'toLoad'\u00a7c, see console for more info!", false);
        }
        if (toLoad == null) {
            toLoad = new HashMap<String, PluginDescription>();
        }
        if (!file.isFile()) return new PluginResult("\u00a77Plugin was loaded successfully!", true);
        try (JarFile jar = new JarFile(file);){
            PluginDescription desc;
            JarEntry pdf = jar.getJarEntry("bungee.yml");
            if (pdf == null) {
                pdf = jar.getJarEntry("plugin.yml");
            }
            if (pdf == null) {
                PluginResult pluginResult = new PluginResult("\u00a7cError while trying to load plugin: \u00a74Plugin does not contain plugin.yml or bungee.yml!", false);
                return pluginResult;
            }
            try (InputStream in = jar.getInputStream(pdf);){
                desc = (PluginDescription)yaml.loadAs(in, PluginDescription.class);
                if (desc.getName() == null) {
                    PluginResult pluginResult = new PluginResult("\u00a7cError while trying to load plugin: \u00a74Plugin does not contain a name in it's plugin.yml/bungee.yml!", false);
                    return pluginResult;
                }
                if (desc.getMain() == null) {
                    PluginResult pluginResult = new PluginResult("\u00a7cError while trying to load plugin: \u00a74Plugin does not contain a main class in it's plugin.yml/bungee.yml!", false);
                    return pluginResult;
                }
                if (pluginManager.getPlugin(desc.getName()) != null) {
                    PluginResult pluginResult = new PluginResult("\u00a7cError while trying to load plugin: \u00a74A plugin named '" + desc.getName() + "' is already loaded!", false);
                    return pluginResult;
                }
                desc.setFile(file);
                toLoad.put(desc.getName(), desc);
            }
            toLoadField.set(pluginManager, toLoad);
            pluginManager.loadPlugins();
            Plugin plugin = pluginManager.getPlugin(desc.getName());
            if (plugin == null) {
                PluginResult pluginResult = new PluginResult("\u00a7cError while trying to load plugin: \u00a74An unknown error occurred\u00a7c, see console for more info!", false);
                return pluginResult;
            }
            plugin.onEnable();
            return new PluginResult("\u00a77Plugin was loaded successfully!", true);
        }
        catch (Exception ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load plugin from file " + file, ex);
            return new PluginResult("\u00a7cError while trying to load plugin: \u00a74An unknown error occurred\u00a7c, see console for more info!", false);
        }
    }
}

