/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import me.mjolnir.mineconomy.MineConomy;
import me.mjolnir.mineconomy.exceptions.AccountNameConflictException;
import me.mjolnir.mineconomy.exceptions.NoAccountException;
import me.mjolnir.mineconomy.internal.MCCom;
import me.mjolnir.mineconomy.internal.util.MCFormat;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_MineConomy
extends AbstractEconomy {
    private final Logger log;
    private final String name = "MineConomy";
    private Plugin plugin = null;
    private MineConomy econ = null;

    public Economy_MineConomy(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.econ == null && (econ = plugin.getServer().getPluginManager().getPlugin("MineConomy")) != null && econ.isEnabled()) {
            this.econ = (MineConomy)econ;
            this.log.info(String.format("[Economy] %s hooked.", "MineConomy"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.econ != null;
    }

    @Override
    public String getName() {
        return "MineConomy";
    }

    @Override
    public String format(double amount) {
        return MCFormat.format((double)amount);
    }

    @Override
    public String currencyNameSingular() {
        return MCCom.getDefaultCurrency();
    }

    @Override
    public String currencyNamePlural() {
        return MCCom.getDefaultCurrency();
    }

    @Override
    public double getBalance(String playerName) {
        try {
            return MCCom.getExternalBalance((String)playerName);
        }
        catch (NoAccountException e) {
            MCCom.create((String)playerName);
            return MCCom.getExternalBalance((String)playerName);
        }
    }

    @Override
    public boolean has(String playerName, double amount) {
        try {
            return MCCom.canExternalAfford((String)playerName, (double)amount);
        }
        catch (NoAccountException e) {
            MCCom.create((String)playerName);
            return MCCom.canExternalAfford((String)playerName, (double)amount);
        }
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        double balance;
        try {
            balance = MCCom.getExternalBalance((String)playerName);
        }
        catch (NoAccountException e) {
            MCCom.create((String)playerName);
            balance = MCCom.getExternalBalance((String)playerName);
        }
        if (amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (balance >= amount) {
            double finalBalance = balance - amount;
            MCCom.setExternalBalance((String)playerName, (double)finalBalance);
            return new EconomyResponse(amount, finalBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        double balance;
        try {
            balance = MCCom.getExternalBalance((String)playerName);
        }
        catch (NoAccountException e) {
            MCCom.create((String)playerName);
            balance = MCCom.getExternalBalance((String)playerName);
        }
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        MCCom.setExternalBalance((String)playerName, (double)(balance += amount));
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return MCCom.exists((String)playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        try {
            MCCom.create((String)playerName);
            return true;
        }
        catch (AccountNameConflictException e) {
            return false;
        }
    }

    @Override
    public int fractionalDigits() {
        return 2;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_MineConomy economy = null;

        public EconomyServerListener(Economy_MineConomy economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.econ == null && (eco = event.getPlugin()).getDescription().getName().equals("MineConomy")) {
                this.economy.econ = (MineConomy)eco;
                Economy_MineConomy.this.log.info(String.format("[Economy] %s hooked.", "MineConomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.econ != null && event.getPlugin().getDescription().getName().equals("MineConomy")) {
                this.economy.econ = null;
                Economy_MineConomy.this.log.info(String.format("[Economy] %s unhooked.", "MineConomy"));
            }
        }
    }
}

