/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.github.gonalez.znpcs.cache.CacheCategory;
import io.github.gonalez.znpcs.cache.CachePackage;
import io.github.gonalez.znpcs.utility.Version;
import io.github.gonalez.znpcs.utility.VersionRange;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface TypeCache {

    public static abstract class BaseCache<T> {
        private static final Logger LOGGER = Logger.getLogger(BaseCache.class.getName());
        protected final CacheBuilder cacheBuilder;
        protected Class<?> BUILDER_CLASS;
        private T cached;
        private boolean loaded = false;

        protected BaseCache(CacheBuilder cacheBuilder) {
            this.cacheBuilder = cacheBuilder;
            for (String classes : cacheBuilder.className) {
                try {
                    this.BUILDER_CLASS = Class.forName(classes);
                    if (!cacheBuilder.foundFirst) continue;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
        }

        public T load() {
            if (this.loaded) {
                return this.cached;
            }
            try {
                T eval;
                if (this.BUILDER_CLASS == null) {
                    throw new IllegalStateException("can't find class for: " + this.cacheBuilder.className);
                }
                T t = eval = this.cached != null ? this.cached : (this.cached = this.onLoad());
                if (eval == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.loaded = true;
            return this.cached;
        }

        private void log(String message) {
            LOGGER.log(Level.WARNING, message);
        }

        protected abstract T onLoad() throws Exception;

        public static class EnumLoader
        extends BaseCache<Enum<?>[]> {
            public EnumLoader(CacheBuilder cacheBuilder) {
                super(cacheBuilder);
            }

            @Override
            protected Enum<?>[] onLoad() {
                Enum[] arrayOfEnum;
                for (Enum enumConstant : arrayOfEnum = (Enum[])this.BUILDER_CLASS.getEnumConstants()) {
                    ClassCache.register(enumConstant.name(), enumConstant, this.BUILDER_CLASS);
                }
                return arrayOfEnum;
            }
        }

        public static class ConstructorLoader
        extends BaseCache<Constructor<?>> {
            public ConstructorLoader(CacheBuilder cacheBuilder) {
                super(cacheBuilder);
            }

            @Override
            protected Constructor<?> onLoad() throws NoSuchMethodException {
                Constructor constructor = null;
                if (Iterables.size((Iterable)this.cacheBuilder.parameterTypes) > 1) {
                    for (Class[] keyParameters : this.cacheBuilder.parameterTypes) {
                        try {
                            constructor = this.BUILDER_CLASS.getDeclaredConstructor(keyParameters);
                            return constructor;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                    }
                } else {
                    Constructor constructor2 = constructor = Iterables.size((Iterable)this.cacheBuilder.parameterTypes) > 0 ? this.BUILDER_CLASS.getDeclaredConstructor((Class[])Iterables.get((Iterable)this.cacheBuilder.parameterTypes, (int)0)) : this.BUILDER_CLASS.getDeclaredConstructor(new Class[0]);
                }
                if (constructor != null) {
                    constructor.setAccessible(true);
                }
                return constructor;
            }
        }

        public static class FieldLoader
        extends BaseCache<Field> {
            public FieldLoader(CacheBuilder cacheBuilder) {
                super(cacheBuilder);
            }

            @Override
            protected Field onLoad() throws NoSuchFieldException {
                if (this.cacheBuilder.expectType != null) {
                    for (Class currentClass = this.BUILDER_CLASS; currentClass != null; currentClass = currentClass.getSuperclass()) {
                        for (Field field1 : currentClass.getDeclaredFields()) {
                            if (field1.getType() != this.cacheBuilder.expectType) continue;
                            field1.setAccessible(true);
                            return field1;
                        }
                    }
                }
                Field field = null;
                if (this.BUILDER_CLASS != null) {
                    field = this.BUILDER_CLASS.getDeclaredField(this.cacheBuilder.fieldName);
                }
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) {
                    try {
                        ClassCache.register(field.getName(), field.get(null), field.getDeclaringClass());
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                return field;
            }

            public AsValueField asValueField() {
                return new AsValueField(this);
            }

            private static class AsValueField
            extends BaseCache<Object> {
                private final FieldLoader fieldLoader;

                public AsValueField(FieldLoader fieldLoader) {
                    super(fieldLoader.cacheBuilder);
                    this.fieldLoader = fieldLoader;
                }

                @Override
                protected Object onLoad() throws IllegalAccessException, NoSuchFieldException {
                    Field field = this.fieldLoader.onLoad();
                    return field.get(null);
                }
            }
        }

        public static class MethodLoader
        extends BaseCache<Method> {
            public MethodLoader(CacheBuilder builder) {
                super(builder);
            }

            @Override
            protected Method onLoad() {
                Method method;
                Method maybeFindAtFirst = this.findMethodByReturnType(this.cacheBuilder.expectType);
                if (maybeFindAtFirst != null) {
                    return maybeFindAtFirst;
                }
                if (this.cacheBuilder.searchByParameters && (method = (Method)Arrays.stream(this.BUILDER_CLASS.getDeclaredMethods()).filter(method1 -> Iterables.elementsEqual((Iterable)ImmutableList.copyOf((Object[])method1.getParameterTypes()), (Iterable)ImmutableList.copyOf((Object[])((Class[])this.cacheBuilder.parameterTypes.get(0))))).findFirst().orElse(null)) != null) {
                    return method;
                }
                Multimap methods = this.cacheBuilder.methods;
                for (Map.Entry entry : methods.entries()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    String methodName = (String)entry.getKey();
                    ImmutableList parameterTypes = this.cacheBuilder.parameterTypes;
                    try {
                        Method[] methodsToSearch;
                        block3: for (Method method2 : methodsToSearch = this.cacheBuilder.foundFirst ? this.BUILDER_CLASS.getDeclaredMethods() : this.BUILDER_CLASS.getMethods()) {
                            if (!this.isValidMethod(method2) || !method2.getName().equals(methodName) || this.cacheBuilder.expectType != null && method2.getReturnType() != this.cacheBuilder.expectType) continue;
                            method2.setAccessible(true);
                            if (!parameterTypes.isEmpty()) {
                                for (Object[] params : parameterTypes) {
                                    if (Iterables.elementsEqual((Iterable)ImmutableList.copyOf((Object[])method2.getParameterTypes()), (Iterable)ImmutableList.copyOf((Object[])params))) continue;
                                    continue block3;
                                }
                            }
                            return method2;
                        }
                        throw new NoSuchMethodException();
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                return null;
            }

            private Method findMethodByReturnType(Class<?> expectedType) {
                if (!this.cacheBuilder.methods.isEmpty()) {
                    return null;
                }
                if (expectedType == null) {
                    return null;
                }
                for (Method method : this.BUILDER_CLASS.getDeclaredMethods()) {
                    method.setAccessible(true);
                    if (!this.isValidMethod(method) || method.getReturnType() != expectedType) continue;
                    return method;
                }
                return null;
            }

            private boolean isValidMethod(Method method) {
                if (!this.cacheBuilder.parameterTypes.isEmpty()) {
                    for (Object[] params : this.cacheBuilder.parameterTypes) {
                        if (Iterables.elementsEqual((Iterable)ImmutableList.copyOf((Object[])method.getParameterTypes()), (Iterable)ImmutableList.copyOf((Object[])params))) continue;
                        return false;
                    }
                }
                return !method.getName().equals("valueOf") && !method.getName().equalsIgnoreCase("getOriginWorld");
            }
        }

        public static class ClazzLoader
        extends BaseCache<Class<?>> {
            public ClazzLoader(CacheBuilder cacheBuilder) {
                super(cacheBuilder);
            }

            @Override
            protected Class<?> onLoad() {
                return this.BUILDER_CLASS;
            }
        }
    }

    public static class CacheBuilder {
        private static final String EMPTY_STRING = "";
        private final CachePackage cachePackage;
        private final CacheCategory cacheCategory;
        private final String fieldName;
        private final List<String> className;
        private final Multimap<String, Boolean> methods;
        private final String additionalData;
        private final ImmutableList<Class<?>[]> parameterTypes;
        private final Class<?> expectType;
        private final boolean foundFirst;
        private final boolean searchByParameters;

        public CacheBuilder(CachePackage cachePackage) {
            this(cachePackage, CacheCategory.DEFAULT, new ArrayList<String>(), EMPTY_STRING, (Multimap<String, Boolean>)LinkedHashMultimap.create(), EMPTY_STRING, (ImmutableList<Class<?>[]>)ImmutableList.of(), null, false, false);
        }

        protected CacheBuilder(CachePackage cachePackage, CacheCategory cacheCategory, List<String> className, String fieldName, Multimap<String, Boolean> methods, String additionalData, ImmutableList<Class<?>[]> parameterTypes, Class<?> expectType, boolean foundFirst, boolean searchByParameters) {
            this.cachePackage = cachePackage;
            this.cacheCategory = cacheCategory;
            this.className = className;
            this.methods = ImmutableMultimap.copyOf(methods);
            this.fieldName = fieldName;
            this.additionalData = additionalData;
            this.parameterTypes = parameterTypes;
            this.expectType = expectType;
            this.foundFirst = foundFirst;
            this.searchByParameters = searchByParameters;
        }

        public CacheBuilder acceptFirst() {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, this.fieldName, this.methods, this.additionalData, this.parameterTypes, this.expectType, true, this.searchByParameters);
        }

        public CacheBuilder searchByParameters() {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, this.fieldName, this.methods, this.additionalData, this.parameterTypes, this.expectType, this.foundFirst, true);
        }

        public CacheBuilder withCategory(CacheCategory category) {
            return new CacheBuilder(this.cachePackage, category, this.className, this.fieldName, this.methods, this.additionalData, this.parameterTypes, this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withClassName(String className) {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, (List<String>)ImmutableList.builder().addAll(this.className).add((Object)this.formatClass(className)).build(), this.fieldName, this.methods, this.additionalData, this.parameterTypes, this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withClassName(Class<?> clazz) {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, (List<String>)ImmutableList.builder().addAll(this.className).add((Object)(clazz == null ? EMPTY_STRING : clazz.getName())).build(), this.fieldName, this.methods, this.additionalData, this.parameterTypes, this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withMethodName(String methodName) {
            return this.withMethodName(methodName, true);
        }

        public CacheBuilder withMethodName(String methodName, boolean isSupported) {
            LinkedHashMultimap newMethods = LinkedHashMultimap.create(this.methods);
            newMethods.put((Object)methodName, (Object)isSupported);
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, this.fieldName, (Multimap<String, Boolean>)newMethods, this.additionalData, this.parameterTypes, this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withMethodName(String methodName, VersionRange ... versionRanges) {
            return this.withMethodName(methodName, Arrays.stream(versionRanges).anyMatch(vr -> vr.rangeContains(Version.SERVER_VERSION)));
        }

        public CacheBuilder withFieldName(String fieldName) {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, fieldName, this.methods, this.additionalData, this.parameterTypes, this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withAdditionalData(String additionalData) {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, this.fieldName, this.methods, additionalData, this.parameterTypes, this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withParameterTypes(Class<?> ... types) {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, this.fieldName, this.methods, this.additionalData, (ImmutableList<Class<?>[]>)ImmutableList.copyOf((Iterable)Iterables.concat(this.parameterTypes, (Iterable)ImmutableList.of(types))), this.expectType, this.foundFirst, this.searchByParameters);
        }

        public CacheBuilder withExpectResult(Class<?> expectType) {
            return new CacheBuilder(this.cachePackage, this.cacheCategory, this.className, this.fieldName, this.methods, this.additionalData, this.parameterTypes, expectType, this.foundFirst, this.searchByParameters);
        }

        protected String formatClass(String className) {
            switch (this.cachePackage) {
                case MINECRAFT_SERVER: 
                case CRAFT_BUKKIT: {
                    return String.format((this.cachePackage == CachePackage.CRAFT_BUKKIT ? this.cachePackage.getFixedPackageName() : this.cachePackage.getForCategory(this.cacheCategory, this.additionalData)) + ".%s", className);
                }
                case DEFAULT: {
                    return className;
                }
            }
            throw new IllegalArgumentException("Unexpected package " + this.cachePackage.name());
        }
    }

    public static class ClassCache {
        protected static final ConcurrentMap<CacheKey, Object> CACHE = new ConcurrentHashMap<CacheKey, Object>();

        public static Object find(String name, Class<?> objectClass) {
            return CACHE.get(new CacheKey(name, objectClass));
        }

        public static void register(String name, Object object, Class<?> objectClass) {
            CACHE.putIfAbsent(new CacheKey(name, objectClass), object);
        }

        private static class CacheKey {
            private final Class<?> type;
            private final String value;

            public CacheKey(String value, Class<?> type) {
                this.type = type;
                this.value = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheKey classKey = (CacheKey)o;
                return Objects.equals(this.type, classKey.type) && Objects.equals(this.value, classKey.value);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.value);
            }
        }
    }
}

