/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc;

import java.util.function.Function;

public enum TypeProperty {
    STRING(String::toString),
    BOOLEAN(Boolean::parseBoolean),
    INT(Integer::parseInt),
    DOUBLE(Double::parseDouble),
    FLOAT(Float::parseFloat),
    SHORT(Short::parseShort),
    LONG(Long::parseLong);

    private final Function<String, ?> function;

    private TypeProperty(Function<String, ?> function) {
        this.function = function;
    }

    public Function<String, ?> getFunction() {
        return this.function;
    }

    public static TypeProperty forType(Class<?> primitiveType) {
        if (primitiveType == String.class) {
            return STRING;
        }
        if (primitiveType == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (primitiveType == Integer.TYPE) {
            return INT;
        }
        if (primitiveType == Double.TYPE) {
            return DOUBLE;
        }
        if (primitiveType == Float.TYPE) {
            return FLOAT;
        }
        if (primitiveType == Short.TYPE) {
            return SHORT;
        }
        if (primitiveType == Long.TYPE) {
            return LONG;
        }
        return null;
    }
}

