/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc.conversation;

import io.github.gonalez.znpcs.npc.NPC;
import io.github.gonalez.znpcs.npc.conversation.Conversation;
import io.github.gonalez.znpcs.npc.conversation.ConversationProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.entity.Player;

public class ConversationModel {
    private String conversationName;
    private ConversationType conversationType;
    private final transient Map<UUID, Long> lastStarted = new HashMap<UUID, Long>();

    public ConversationModel(String conversationName, String conversationType) {
        this.conversationName = conversationName;
        try {
            this.conversationType = ConversationType.valueOf(conversationType.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException("can't find conversation type " + conversationType);
        }
    }

    public String getConversationName() {
        return this.conversationName;
    }

    public ConversationType getConversationType() {
        return this.conversationType;
    }

    public Conversation getConversation() {
        return Conversation.forName(this.conversationName);
    }

    public void startConversation(NPC npc, Player player) {
        long lastConversationNanos;
        if (!Conversation.exists(this.conversationName)) {
            throw new IllegalStateException("can't find conversation " + this.conversationName);
        }
        if (ConversationProcessor.isPlayerConversing(player.getUniqueId())) {
            return;
        }
        if (this.lastStarted.containsKey(player.getUniqueId()) && (lastConversationNanos = System.nanoTime() - this.lastStarted.get(player.getUniqueId())) < 1000000000L * (long)this.getConversation().getDelay()) {
            return;
        }
        this.lastStarted.remove(player.getUniqueId());
        if (this.conversationType.canStart(npc, this.getConversation(), player)) {
            new ConversationProcessor(npc, this, player);
            this.lastStarted.put(player.getUniqueId(), System.nanoTime());
        }
    }

    public boolean canRun(NPC npc, Player player) {
        return Stream.of(ConversationType.values()).anyMatch(conversationType1 -> !conversationType1.canStart(npc, this.getConversation(), player));
    }

    private ConversationModel() {
    }

    public static enum ConversationType {
        RADIUS{

            @Override
            public boolean canStart(NPC npc, Conversation conversation, Player player) {
                return player.getWorld() == npc.getLocation().getWorld() && player.getLocation().distance(npc.getLocation()) <= (double)conversation.getRadius();
            }
        }
        ,
        CLICK{

            @Override
            public boolean canStart(NPC npc, Conversation conversation, Player player) {
                return true;
            }
        };


        abstract boolean canStart(NPC var1, Conversation var2, Player var3);
    }
}

