/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.npc.packet;

import com.google.common.collect.ImmutableMap;
import io.github.gonalez.znpcs.npc.packet.Packet;
import io.github.gonalez.znpcs.npc.packet.PacketFactory;
import io.github.gonalez.znpcs.npc.packet.PacketValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PacketCache {
    protected static final ImmutableMap<Method, PacketValue> VALUE_LOOKUP_BY_NAME;
    private final Map<String, Object> packetResultCache = new ConcurrentHashMap<String, Object>();
    private final Packet proxyInstance;

    public PacketCache(Packet packet) {
        this.proxyInstance = this.newProxyInstance(packet);
    }

    public PacketCache() {
        this(PacketFactory.PACKET_FOR_CURRENT_VERSION);
    }

    public Packet getProxyInstance() {
        return this.proxyInstance;
    }

    protected Packet newProxyInstance(Packet packet) {
        return (Packet)Proxy.newProxyInstance(packet.getClass().getClassLoader(), new Class[]{Packet.class}, (InvocationHandler)new PacketHandler(this, packet));
    }

    private Object getOrCache(Packet instance, Method method, Object[] args) {
        if (!VALUE_LOOKUP_BY_NAME.containsKey((Object)method)) {
            throw new IllegalStateException("value not found for method: " + method.getName());
        }
        PacketValue packetValue = (PacketValue)VALUE_LOOKUP_BY_NAME.get((Object)method);
        String keyString = packetValue.valueType().resolve(packetValue.keyName(), args);
        return this.packetResultCache.computeIfAbsent(keyString, o -> {
            try {
                return method.invoke((Object)instance, args);
            }
            catch (IllegalAccessException | InvocationTargetException operationException) {
                throw new AssertionError("can't invoke method: " + method.getName(), operationException);
            }
        });
    }

    public void flushCache(String ... strings) {
        Set<Map.Entry<String, Object>> set = this.packetResultCache.entrySet();
        for (String string : strings) {
            set.removeIf(entry -> ((String)entry.getKey()).startsWith(string));
        }
    }

    public void flushCache() {
        this.flushCache((String[])VALUE_LOOKUP_BY_NAME.values().stream().map(PacketValue::keyName).toArray(String[]::new));
    }

    static {
        ImmutableMap.Builder methodPacketValueBuilder = ImmutableMap.builder();
        for (Method method : Packet.class.getMethods()) {
            if (!method.isAnnotationPresent(PacketValue.class)) continue;
            methodPacketValueBuilder.put((Object)method, (Object)method.getAnnotation(PacketValue.class));
        }
        VALUE_LOOKUP_BY_NAME = methodPacketValueBuilder.build();
    }

    private static class PacketHandler
    implements InvocationHandler {
        private final PacketCache packetCache;
        private final Packet packets;

        public PacketHandler(PacketCache packetCache, Packet packets) {
            this.packetCache = packetCache;
            this.packets = packets;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (VALUE_LOOKUP_BY_NAME.containsKey((Object)method)) {
                return this.packetCache.getOrCache(this.packets, method, args);
            }
            return method.invoke((Object)this.packets, args);
        }
    }
}

