/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.skin;

import com.google.gson.JsonObject;
import io.github.gonalez.znpcs.skin.SkinFetchHttp;
import io.github.gonalez.znpcs.skin.SkinFetcherServer;
import io.github.gonalez.znpcs.skin.SkinProperties;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.jetbrains.annotations.Nullable;

public class MineSkinFetch
extends SkinFetcherServer {
    @Override
    public String getName() {
        return "MineSkin";
    }

    @Override
    HttpURLConnection createConnection(String name) throws IOException {
        HttpURLConnection connection = SkinFetchHttp.openConnection(SkinFetchHttp.RequestMethod.POST, "https://api.mineskin.org/generate/url");
        connection.setDoOutput(true);
        try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
            outputStream.writeBytes("url=" + URLEncoder.encode(name, "UTF-8"));
        }
        return connection;
    }

    @Override
    @Nullable
    SkinProperties decodeProperties(SkinFetchHttp.HttpResponse response) {
        JsonObject properties = response.toJson().getAsJsonObject().getAsJsonObject("data").getAsJsonObject("texture");
        return new SkinProperties(properties.get("value").getAsString(), properties.get("signature").getAsString());
    }
}

