/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.skin;

import com.google.gson.JsonObject;
import io.github.gonalez.znpcs.skin.SkinFetchHttp;
import io.github.gonalez.znpcs.skin.SkinFetcherServer;
import io.github.gonalez.znpcs.skin.SkinProperties;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.jetbrains.annotations.Nullable;

public class MojangNameSkinFetch
extends SkinFetcherServer {
    private static final String QUERY_PLAYER_UUID_URL = "https://api.mojang.com/users/profiles/minecraft/%s";
    private static final String QUERY_PLAYER_SKIN_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";

    @Override
    public String getName() {
        return "Mojang";
    }

    @Override
    HttpURLConnection createConnection(String name) throws IOException {
        SkinFetchHttp.HttpResponse response = this.readHttpResponse(SkinFetchHttp.openConnection(SkinFetchHttp.RequestMethod.GET, String.format(QUERY_PLAYER_UUID_URL, name)));
        return SkinFetchHttp.openConnection(SkinFetchHttp.RequestMethod.GET, String.format(QUERY_PLAYER_SKIN_URL, response.toJson().getAsJsonObject().get("id").getAsString()));
    }

    @Override
    @Nullable
    SkinProperties decodeProperties(SkinFetchHttp.HttpResponse response) {
        JsonObject properties = response.toJson().getAsJsonObject().getAsJsonArray("properties").get(0).getAsJsonObject();
        return new SkinProperties(properties.get("value").getAsString(), properties.get("signature").getAsString());
    }
}

