/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.user;

import com.mojang.authlib.GameProfile;
import io.github.gonalez.znpcs.ServersNPC;
import io.github.gonalez.znpcs.cache.CacheRegistry;
import io.github.gonalez.znpcs.npc.NPC;
import io.github.gonalez.znpcs.npc.NPCAction;
import io.github.gonalez.znpcs.npc.event.ClickType;
import io.github.gonalez.znpcs.npc.event.NPCInteractEvent;
import io.github.gonalez.znpcs.user.EventService;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ZUser {
    private static final String CHANNEL_NAME = "npc_interact";
    private static final int DEFAULT_DELAY = 1;
    private static final Map<UUID, ZUser> USER_MAP = new ConcurrentHashMap<UUID, ZUser>();
    private final Map<Integer, Long> lastClicked;
    private final List<EventService<?>> eventServices;
    private final UUID uuid;
    private final GameProfile gameProfile;
    private final Object playerConnection;
    private boolean hasPath = false;
    private long lastInteract = 0L;

    public ZUser(UUID uuid) {
        this.uuid = uuid;
        this.lastClicked = new HashMap<Integer, Long>();
        this.eventServices = new ArrayList();
        try {
            Object playerHandle = CacheRegistry.GET_HANDLE_PLAYER_METHOD.load().invoke((Object)this.toPlayer(), new Object[0]);
            this.gameProfile = (GameProfile)CacheRegistry.GET_PROFILE_METHOD.load().invoke(playerHandle, new Object[0]);
            this.playerConnection = CacheRegistry.PLAYER_CONNECTION_FIELD.load().get(playerHandle);
            Channel channel = (Channel)CacheRegistry.CHANNEL_FIELD.load().get(CacheRegistry.NETWORK_MANAGER_FIELD.load().get(this.playerConnection));
            if (channel.pipeline().names().contains(CHANNEL_NAME)) {
                channel.pipeline().remove(CHANNEL_NAME);
            }
            channel.pipeline().addAfter("decoder", CHANNEL_NAME, (ChannelHandler)new ZNPCSocketDecoder());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("can't create player " + uuid.toString(), e.getCause());
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public Object getPlayerConnection() {
        return this.playerConnection;
    }

    public boolean isHasPath() {
        return this.hasPath;
    }

    public List<EventService<?>> getEventServices() {
        return this.eventServices;
    }

    public void setHasPath(boolean hasPath) {
        this.hasPath = hasPath;
    }

    public Player toPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public static ZUser find(UUID uuid) {
        return USER_MAP.computeIfAbsent(uuid, ZUser::new);
    }

    public static ZUser find(Player player) {
        return ZUser.find(player.getUniqueId());
    }

    public static void unregister(Player player) {
        ZUser zUser = USER_MAP.get(player.getUniqueId());
        if (zUser == null) {
            throw new IllegalStateException("can't find user " + player.getUniqueId());
        }
        USER_MAP.remove(player.getUniqueId());
        NPC.all().stream().filter(npc -> npc.getViewers().contains(zUser)).forEach(npc -> npc.delete(zUser));
    }

    class ZNPCSocketDecoder
    extends MessageToMessageDecoder<Object> {
        ZNPCSocketDecoder() {
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, Object packet, List<Object> out) throws Exception {
            out.add(packet);
            if (packet.getClass() == CacheRegistry.PACKET_PLAY_IN_USE_ENTITY_CLASS) {
                long lastInteractNanos = System.nanoTime() - ZUser.this.lastInteract;
                if (ZUser.this.lastInteract != 0L && lastInteractNanos < 1000000000L) {
                    return;
                }
                int entityId = CacheRegistry.PACKET_IN_USE_ENTITY_ID_FIELD.load().getInt(packet);
                NPC npc = NPC.all().stream().filter(npc1 -> npc1.getEntityID() == entityId).findFirst().orElse(null);
                if (npc == null) {
                    return;
                }
                ClickType clickName = ClickType.forName(npc.getPackets().getProxyInstance().getClickType(packet).toString());
                ZUser.this.lastInteract = System.nanoTime();
                ServersNPC.SCHEDULER.scheduleSyncDelayedTask(() -> {
                    Bukkit.getServer().getPluginManager().callEvent((Event)new NPCInteractEvent(ZUser.this.toPlayer(), clickName, npc));
                    List<NPCAction> actions = npc.getNpcPojo().getClickActions();
                    if (actions == null || actions.isEmpty()) {
                        return;
                    }
                    for (NPCAction npcAction : actions) {
                        if (npcAction.getClickType() != ClickType.DEFAULT && clickName != npcAction.getClickType()) continue;
                        if (npcAction.getDelay() > 0) {
                            long lastClickNanos;
                            int actionId = npc.getNpcPojo().getClickActions().indexOf(npcAction);
                            if (ZUser.this.lastClicked.containsKey(actionId) && (lastClickNanos = System.nanoTime() - (Long)ZUser.this.lastClicked.get(actionId)) < npcAction.getFixedDelay()) continue;
                            ZUser.this.lastClicked.put(actionId, System.nanoTime());
                        }
                        npcAction.run(ZUser.this, npcAction.getAction());
                    }
                }, 1);
            }
        }
    }
}

