/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.utility;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v?(\\d+)\\.(\\d+)(?:\\.(\\d+))?(-R(\\d+\\.\\d+))?(?:-SNAPSHOT)?$");
    public static final Version SERVER_VERSION = Version.fromString(Bukkit.getBukkitVersion());
    static Version MAX_VERSION = new Version("", 2.147483647E9, 0);
    final String versionString;
    final double versionNumber;
    final int subVersion;

    private Version(String versionString, double versionNumber, int subVersion) {
        this.versionString = versionString;
        this.versionNumber = versionNumber;
        this.subVersion = subVersion;
    }

    public static Version fromString(String versionString) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)versionString) ? 1 : 0) != 0);
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            String subminor = matcher.group(3);
            String subVersionStr = matcher.group(4);
            double versionNumber = Double.parseDouble(minor + (subminor == null ? "" : "." + subminor));
            Integer subVersion = 0;
            if (subVersionStr != null && !subVersionStr.isEmpty()) {
                String cleanedSubVersionStr = subVersionStr.replaceAll("[^\\d]", "");
                subVersion = Integer.parseInt(cleanedSubVersionStr);
            }
            return new Version(versionString, versionNumber, subVersion);
        }
        throw new IllegalArgumentException("Invalid version: " + versionString);
    }

    @Override
    public int compareTo(Version other) {
        return Double.compare(this.versionNumber, other.versionNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("versionString", (Object)this.versionString).add("versionNumber", this.versionNumber).add("subVersion", this.subVersion).toString();
    }

    public static enum Type {
        SPIGOT,
        PAPER_SPIGOT;

    }
}

