/*
 * Decompiled with CFR 0.152.
 */
package io.github.gonalez.znpcs.utility.inventory;

import io.github.gonalez.znpcs.utility.Utils;
import io.github.gonalez.znpcs.utility.inventory.ZInventoryHolder;
import io.github.gonalez.znpcs.utility.inventory.ZInventoryPage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ZInventory {
    private static final int MAX_ROWS = 6;
    private final Player player;
    private ZInventoryPage page;
    private Inventory inventory;

    public ZInventory(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ZInventoryPage getPage() {
        return this.page;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setCurrentPage(ZInventoryPage page) {
        this.page = page;
    }

    public Inventory build(ZInventoryPage page) {
        if (page == null) {
            throw new IllegalStateException("page is null");
        }
        if (page.getRows() / 9 > 6) {
            throw new IllegalArgumentException(String.format("Unexpected rows size. Has %d, max %d", page.getRows(), 6));
        }
        this.setCurrentPage(page);
        page.getInventoryItems().removeIf(zInventoryItem -> !zInventoryItem.isDefault());
        page.update();
        this.inventory = Bukkit.createInventory((InventoryHolder)new ZInventoryHolder(this), (int)page.getRows(), (String)Utils.toColor(page.getPageName()));
        page.getInventoryItems().forEach(zInventoryItem -> this.inventory.setItem(zInventoryItem.getSlot(), zInventoryItem.getItemStack()));
        return this.inventory;
    }

    public Inventory build() {
        return this.build(this.page);
    }
}

